/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.template.freemarker;

import com.jfinal.kit.PathKit;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class FreemarkerLoader {
    private Configuration configuration;
    private Map<Object, Object> parameters = new HashMap<Object, Object>();
    private String file = "";

    public FreemarkerLoader(String file) {
        this("", file);
    }

    public FreemarkerLoader(String templatePath, String file) {
        this.file = file;
        this.configuration = new Configuration();
        ArrayList<FileTemplateLoader> loaders = new ArrayList<FileTemplateLoader>();
        try {
            Enumeration<URL> resources = FreemarkerLoader.class.getClassLoader().getResources(templatePath);
            URL resource = null;
            while (resources.hasMoreElements()) {
                resource = resources.nextElement();
                loaders.add(new FileTemplateLoader(new File(resource.getFile())));
            }
            File webDir = new File(PathKit.getWebRootPath() + File.separator + templatePath);
            if (webDir.exists()) {
                loaders.add(new FileTemplateLoader(webDir));
            }
            TemplateLoader[] templateLoaders = new TemplateLoader[loaders.size()];
            this.configuration.setTemplateLoader((TemplateLoader)new MultiTemplateLoader(loaders.toArray(templateLoaders)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.configuration.setEncoding(Locale.getDefault(), "UTF-8");
        this.configuration.setDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    public FreemarkerLoader setEncoding(String encoding) {
        this.configuration.setEncoding(Locale.getDefault(), encoding);
        return this;
    }

    public FreemarkerLoader setDateFormat(String datefmt) {
        this.configuration.setDateFormat(datefmt);
        return this;
    }

    public FreemarkerLoader setValue(String attr, Object value) {
        this.parameters.put(attr, value);
        return this;
    }

    public String getHtml() {
        try {
            Template template = this.configuration.getTemplate(this.file);
            StringWriter stringWriter = new StringWriter();
            template.process(this.parameters, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

