/*
 * Decompiled with CFR 0.152.
 */
package ro.fortsoft.pf4j.spring;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import ro.fortsoft.pf4j.ExtensionFactory;
import ro.fortsoft.pf4j.Plugin;
import ro.fortsoft.pf4j.PluginManager;
import ro.fortsoft.pf4j.PluginWrapper;
import ro.fortsoft.pf4j.spring.SpringPlugin;

public class SpringExtensionFactory
implements ExtensionFactory {
    private static final Logger log = LoggerFactory.getLogger(SpringExtensionFactory.class);
    private PluginManager pluginManager;
    private boolean autowire;

    public SpringExtensionFactory(PluginManager pluginManager) {
        this(pluginManager, true);
    }

    public SpringExtensionFactory(PluginManager pluginManager, boolean autowire) {
        this.pluginManager = pluginManager;
        this.autowire = autowire;
    }

    public Object create(Class<?> extensionClass) {
        Plugin plugin;
        PluginWrapper pluginWrapper;
        Object extension = this.createWithoutSpring(extensionClass);
        if (this.autowire && extension != null && (pluginWrapper = this.pluginManager.whichPlugin(extensionClass)) != null && (plugin = pluginWrapper.getPlugin()) instanceof SpringPlugin) {
            ApplicationContext pluginContext = ((SpringPlugin)plugin).getApplicationContext();
            pluginContext.getAutowireCapableBeanFactory().autowireBean(extension);
        }
        return extension;
    }

    protected Object createWithoutSpring(Class<?> extensionClass) {
        try {
            return extensionClass.newInstance();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

