/*
 * Decompiled with CFR 0.152.
 */
package ro.fortsoft.pf4j.spring;

import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import ro.fortsoft.pf4j.ExtensionFactory;
import ro.fortsoft.pf4j.PluginManager;
import ro.fortsoft.pf4j.PluginWrapper;

public class ExtensionsInjector
implements BeanFactoryPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(ExtensionsInjector.class);

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        PluginManager pluginManager = (PluginManager)beanFactory.getBean(PluginManager.class);
        ExtensionFactory extensionFactory = pluginManager.getExtensionFactory();
        Set extensionClassNames = pluginManager.getExtensionClassNames(null);
        for (String extensionClassName : extensionClassNames) {
            try {
                log.debug("Register extension '{}' as bean", (Object)extensionClassName);
                Class<?> extensionClass = this.getClass().getClassLoader().loadClass(extensionClassName);
                beanFactory.registerSingleton(extensionClassName, extensionFactory.create(extensionClass));
            }
            catch (ClassNotFoundException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        List startedPlugins = pluginManager.getStartedPlugins();
        for (PluginWrapper plugin : startedPlugins) {
            log.debug("Registering extensions of the plugin '{}' as beans", (Object)plugin.getPluginId());
            extensionClassNames = pluginManager.getExtensionClassNames(plugin.getPluginId());
            for (String extensionClassName : extensionClassNames) {
                try {
                    log.debug("Register extension '{}' as bean", (Object)extensionClassName);
                    Class<?> extensionClass = plugin.getPluginClassLoader().loadClass(extensionClassName);
                    beanFactory.registerSingleton(extensionClassName, extensionFactory.create(extensionClass));
                }
                catch (ClassNotFoundException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

