/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.IStandardVariableExpression;
import org.thymeleaf.standard.expression.IStandardVariableExpressionEvaluator;
import org.thymeleaf.standard.expression.SimpleExpression;
import org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.thymeleaf.util.Validate;

public final class VariableExpression
extends SimpleExpression
implements IStandardVariableExpression {
    private static final Logger logger = LoggerFactory.getLogger(VariableExpression.class);
    private static final long serialVersionUID = -4911752782987240708L;
    static final char SELECTOR = '$';
    private static final Pattern VAR_PATTERN = Pattern.compile("^\\s*\\$\\{(.+?)\\}\\s*$", 32);
    static final Expression NULL_VALUE = VariableExpression.parseVariableExpression("${null}");
    private final String expression;
    private final boolean convertToString;
    private volatile Object cachedExpression = null;

    public VariableExpression(String expression) {
        this(expression, false);
    }

    public VariableExpression(String expression, boolean convertToString) {
        Validate.notNull(expression, "Expression cannot be null");
        this.expression = expression;
        this.convertToString = convertToString;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    @Override
    public boolean getUseSelectionAsRoot() {
        return false;
    }

    public boolean getConvertToString() {
        return this.convertToString;
    }

    public Object getCachedExpression() {
        return this.cachedExpression;
    }

    public void setCachedExpression(Object cachedExpression) {
        this.cachedExpression = cachedExpression;
    }

    @Override
    public String getStringRepresentation() {
        return String.valueOf('$') + String.valueOf('{') + (this.convertToString ? String.valueOf('{') : "") + this.expression + (this.convertToString ? String.valueOf('}') : "") + String.valueOf('}');
    }

    static VariableExpression parseVariableExpression(String input) {
        Matcher matcher = VAR_PATTERN.matcher(input);
        if (!matcher.matches()) {
            return null;
        }
        String expression = matcher.group(1);
        int expressionLen = expression.length();
        if (expressionLen > 2 && expression.charAt(0) == '{' && expression.charAt(expressionLen - 1) == '}') {
            return new VariableExpression(expression.substring(1, expressionLen - 1), true);
        }
        return new VariableExpression(expression, false);
    }

    static Object executeVariableExpression(IExpressionContext context, VariableExpression expression, IStandardVariableExpressionEvaluator expressionEvaluator, StandardExpressionExecutionContext expContext) {
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating variable expression: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        StandardExpressionExecutionContext evalExpContext = expression.getConvertToString() ? expContext.withTypeConversion() : expContext.withoutTypeConversion();
        return expressionEvaluator.evaluate(context, expression, evalExpContext);
    }
}

