/*
 * =============================================================================
 * 
 *   Copyright (c) 2011-2014, The THYMELEAF team (http://www.thymeleaf.org)
 * 
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 * 
 *       http://www.apache.org/licenses/LICENSE-2.0
 * 
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 * 
 * =============================================================================
 */
package org.thymeleaf.standard.processor.attr;

import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;

/**
 * Similar to <b>th:include</b>, but instead of adding the specified template
 * fragment as a child of this element, it will replace this element with the
 * template fragment.
 * 
 * @author Daniel Fern&aacute;ndez
 * @since 2.1.0
 */
public class StandardReplaceFragmentAttrProcessor
        extends AbstractStandardFragmentHandlingAttrProcessor {

    public static final int ATTR_PRECEDENCE = 100;
    public static final String ATTR_NAME = "replace";
    public static final String FRAGMENT_ATTR_NAME = StandardFragmentAttrProcessor.ATTR_NAME;




    public StandardReplaceFragmentAttrProcessor() {
        super(ATTR_NAME);
    }



    @Override
    public int getPrecedence() {
        return ATTR_PRECEDENCE;
    }



    @Override
    protected String getFragmentSignatureUnprefixedAttributeName(
            final Arguments arguments, final Element element,
            final String attributeName, final String attributeValue) {

        return FRAGMENT_ATTR_NAME;
        
    }



    @Override
    protected boolean getRemoveHostNode(
            final Arguments arguments,
            final Element element, final String attributeName, final String attributeValue) {
        // th:replace does replace the inclusion node
        return true;
    }



    
}
