/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.fragment;

import java.util.HashMap;
import java.util.Map;
import org.thymeleaf.Configuration;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.fragment.DOMSelectorFragmentSpec;
import org.thymeleaf.fragment.WholeFragmentSpec;
import org.thymeleaf.standard.expression.Assignation;
import org.thymeleaf.standard.expression.AssignationSequence;
import org.thymeleaf.standard.expression.FragmentSelection;
import org.thymeleaf.standard.expression.FragmentSelectionUtils;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.fragment.StandardFragment;
import org.thymeleaf.standard.fragment.StandardFragmentSignatureNodeReferenceChecker;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StandardFragmentProcessor {
    private static final String TEMPLATE_NAME_CURRENT_TEMPLATE = "this";

    public static StandardFragment computeStandardFragmentSpec(Configuration configuration, IProcessingContext processingContext, String standardFragmentSpec, String dialectPrefix, String fragmentSignatureAttributeName) {
        String templateName;
        Validate.notNull(processingContext, "Processing Context cannot be null");
        Validate.notEmpty(standardFragmentSpec, "Fragment Spec cannot be null");
        FragmentSelection fragmentSelection = FragmentSelectionUtils.parseFragmentSelection(configuration, processingContext, standardFragmentSpec);
        IStandardExpression templateNameExpression = fragmentSelection.getTemplateName();
        if (templateNameExpression != null) {
            Object templateNameObject = templateNameExpression.execute(configuration, processingContext);
            if (templateNameObject == null) {
                throw new TemplateProcessingException("Evaluation of template name from spec \"" + standardFragmentSpec + "\" " + "returned null.");
            }
            String evaluatedTemplateName = templateNameObject.toString();
            templateName = TEMPLATE_NAME_CURRENT_TEMPLATE.equals(evaluatedTemplateName) ? null : templateNameObject.toString();
        } else {
            templateName = null;
        }
        Map<String, Object> fragmentParameters = StandardFragmentProcessor.resolveFragmentParameters(configuration, processingContext, fragmentSelection.getParameters());
        if (fragmentSelection.hasFragmentSelector()) {
            Object fragmentSelectorObject = fragmentSelection.getFragmentSelector().execute(configuration, processingContext);
            if (fragmentSelectorObject == null) {
                throw new TemplateProcessingException("Evaluation of fragment selector from spec \"" + standardFragmentSpec + "\" " + "returned null.");
            }
            String fragmentSelector = fragmentSelectorObject.toString();
            if (fragmentSelector.length() > 3 && fragmentSelector.charAt(0) == '[' && fragmentSelector.charAt(fragmentSelector.length() - 1) == ']' && fragmentSelector.charAt(fragmentSelector.length() - 2) != '\'') {
                fragmentSelector = fragmentSelector.substring(1, fragmentSelector.length() - 1);
            }
            StandardFragmentSignatureNodeReferenceChecker nodeReferenceChecker = new StandardFragmentSignatureNodeReferenceChecker(configuration, dialectPrefix, fragmentSignatureAttributeName);
            DOMSelectorFragmentSpec fragmentSpec = new DOMSelectorFragmentSpec(fragmentSelector, nodeReferenceChecker);
            return new StandardFragment(templateName, fragmentSpec, fragmentParameters, dialectPrefix, fragmentSignatureAttributeName);
        }
        return new StandardFragment(templateName, WholeFragmentSpec.INSTANCE, fragmentParameters);
    }

    private static Map<String, Object> resolveFragmentParameters(Configuration configuration, IProcessingContext processingContext, AssignationSequence parameters) {
        if (parameters == null) {
            return null;
        }
        HashMap<String, Object> parameterValues = new HashMap<String, Object>(parameters.size() + 2);
        for (Assignation assignation : parameters.getAssignations()) {
            IStandardExpression parameterNameExpr = assignation.getLeft();
            Object parameterNameValue = parameterNameExpr.execute(configuration, processingContext);
            String parameterName = parameterNameValue == null ? null : parameterNameValue.toString();
            IStandardExpression parameterValueExpr = assignation.getRight();
            Object parameterValueValue = parameterValueExpr.execute(configuration, processingContext);
            parameterValues.put(parameterName, parameterValueValue);
        }
        return parameterValues;
    }

    private StandardFragmentProcessor() {
    }
}

