/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import org.thymeleaf.Configuration;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.AdditionExpression;
import org.thymeleaf.standard.expression.AndExpression;
import org.thymeleaf.standard.expression.ConditionalExpression;
import org.thymeleaf.standard.expression.DefaultExpression;
import org.thymeleaf.standard.expression.DivisionExpression;
import org.thymeleaf.standard.expression.EqualsExpression;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.GreaterOrEqualToExpression;
import org.thymeleaf.standard.expression.GreaterThanExpression;
import org.thymeleaf.standard.expression.LessOrEqualToExpression;
import org.thymeleaf.standard.expression.LessThanExpression;
import org.thymeleaf.standard.expression.MinusExpression;
import org.thymeleaf.standard.expression.MultiplicationExpression;
import org.thymeleaf.standard.expression.NegationExpression;
import org.thymeleaf.standard.expression.NotEqualsExpression;
import org.thymeleaf.standard.expression.OrExpression;
import org.thymeleaf.standard.expression.RemainderExpression;
import org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.thymeleaf.standard.expression.SubtractionExpression;

public abstract class ComplexExpression
extends Expression {
    private static final long serialVersionUID = -3807499386899890260L;

    protected ComplexExpression() {
    }

    static Object executeComplex(Configuration configuration, IProcessingContext processingContext, ComplexExpression expression, StandardExpressionExecutionContext expContext) {
        if (expression instanceof AdditionExpression) {
            return AdditionExpression.executeAddition(configuration, processingContext, (AdditionExpression)expression, expContext);
        }
        if (expression instanceof SubtractionExpression) {
            return SubtractionExpression.executeSubtraction(configuration, processingContext, (SubtractionExpression)expression, expContext);
        }
        if (expression instanceof MultiplicationExpression) {
            return MultiplicationExpression.executeMultiplication(configuration, processingContext, (MultiplicationExpression)expression, expContext);
        }
        if (expression instanceof DivisionExpression) {
            return DivisionExpression.executeDivision(configuration, processingContext, (DivisionExpression)expression, expContext);
        }
        if (expression instanceof RemainderExpression) {
            return RemainderExpression.executeRemainder(configuration, processingContext, (RemainderExpression)expression, expContext);
        }
        if (expression instanceof ConditionalExpression) {
            return ConditionalExpression.executeConditional(configuration, processingContext, (ConditionalExpression)expression, expContext);
        }
        if (expression instanceof DefaultExpression) {
            return DefaultExpression.executeDefault(configuration, processingContext, (DefaultExpression)expression, expContext);
        }
        if (expression instanceof MinusExpression) {
            return MinusExpression.executeMinus(configuration, processingContext, (MinusExpression)expression, expContext);
        }
        if (expression instanceof NegationExpression) {
            return NegationExpression.executeNegation(configuration, processingContext, (NegationExpression)expression, expContext);
        }
        if (expression instanceof AndExpression) {
            return AndExpression.executeAnd(configuration, processingContext, (AndExpression)expression, expContext);
        }
        if (expression instanceof OrExpression) {
            return OrExpression.executeOr(configuration, processingContext, (OrExpression)expression, expContext);
        }
        if (expression instanceof EqualsExpression) {
            return EqualsExpression.executeEquals(configuration, processingContext, (EqualsExpression)expression, expContext);
        }
        if (expression instanceof NotEqualsExpression) {
            return NotEqualsExpression.executeNotEquals(configuration, processingContext, (NotEqualsExpression)expression, expContext);
        }
        if (expression instanceof GreaterThanExpression) {
            return GreaterThanExpression.executeGreaterThan(configuration, processingContext, (GreaterThanExpression)expression, expContext);
        }
        if (expression instanceof GreaterOrEqualToExpression) {
            return GreaterOrEqualToExpression.executeGreaterOrEqualTo(configuration, processingContext, (GreaterOrEqualToExpression)expression, expContext);
        }
        if (expression instanceof LessThanExpression) {
            return LessThanExpression.executeLessThan(configuration, processingContext, (LessThanExpression)expression, expContext);
        }
        if (expression instanceof LessOrEqualToExpression) {
            return LessOrEqualToExpression.executeLessOrEqualTo(configuration, processingContext, (LessOrEqualToExpression)expression, expContext);
        }
        throw new TemplateProcessingException("Unrecognized complex expression: " + expression.getClass().getName());
    }
}

