/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.processor.document;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.dom.Document;
import org.thymeleaf.dom.Node;
import org.thymeleaf.processor.AbstractProcessor;
import org.thymeleaf.processor.IDocumentNodeProcessorMatcher;
import org.thymeleaf.processor.IProcessorMatcher;
import org.thymeleaf.processor.ProcessorMatchingContext;
import org.thymeleaf.processor.ProcessorResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDocumentProcessor
extends AbstractProcessor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final IDocumentNodeProcessorMatcher matcher;

    protected AbstractDocumentProcessor(IDocumentNodeProcessorMatcher matcher) {
        this.matcher = matcher;
    }

    public IProcessorMatcher<? extends Document> getMatcher() {
        return this.matcher;
    }

    @Override
    protected final ProcessorResult doProcess(Arguments arguments, ProcessorMatchingContext processorMatchingContext, Node node) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("[THYMELEAF][{}][{}] Processing Document node of type \"{}\".", new Object[]{TemplateEngine.threadIndex(), arguments.getTemplateName(), node.getClass().getName()});
        }
        return this.processDocumentNode(arguments, (Document)node);
    }

    protected abstract ProcessorResult processDocumentNode(Arguments var1, Document var2);
}

