/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.processor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.thymeleaf.dom.Attribute;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.NestableAttributeHolderNode;
import org.thymeleaf.dom.Node;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorMatchingContext;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AttributeNameProcessorMatcher
implements IAttributeNameProcessorMatcher {
    private final String attributeName;
    private final String elementNameFilter;
    private final Map<String, String> attributeValuesByNameFilter;

    public AttributeNameProcessorMatcher(String attributeName) {
        this(attributeName, null, null);
    }

    public AttributeNameProcessorMatcher(String attributeName, String elementNameFilter) {
        this(attributeName, elementNameFilter, null);
    }

    public AttributeNameProcessorMatcher(String attributeName, String elementNameFilter, String filterAttributeName, String filterAttributeValue) {
        this(attributeName, elementNameFilter, Collections.singletonMap(filterAttributeName, filterAttributeValue));
    }

    public AttributeNameProcessorMatcher(String attributeName, String elementNameFilter, Map<String, String> attributeValuesByNameFilter) {
        Validate.notEmpty(attributeName, "Attribute name cannot be null or empty");
        this.attributeName = Attribute.normalizeAttributeName(attributeName);
        this.elementNameFilter = Element.normalizeElementName(elementNameFilter);
        if (attributeValuesByNameFilter == null || attributeValuesByNameFilter.size() == 0) {
            this.attributeValuesByNameFilter = null;
        } else {
            HashMap<String, String> newAttributeValuesByNameFilter = new HashMap<String, String>(attributeValuesByNameFilter.size() + 1, 1.0f);
            newAttributeValuesByNameFilter.putAll(attributeValuesByNameFilter);
            this.attributeValuesByNameFilter = Collections.unmodifiableMap(newAttributeValuesByNameFilter);
        }
    }

    @Override
    public String[] getAttributeNames(ProcessorMatchingContext context) {
        return Attribute.applyPrefixToAttributeName(this.attributeName, context.getDialectPrefix());
    }

    public String getElementNameFilter() {
        return this.elementNameFilter;
    }

    public Map<String, String> getAttributeValuesByNameFilter() {
        return this.attributeValuesByNameFilter;
    }

    @Override
    public boolean matches(Node node, ProcessorMatchingContext context) {
        if (!(node instanceof NestableAttributeHolderNode)) {
            return false;
        }
        NestableAttributeHolderNode attributeHolderNode = (NestableAttributeHolderNode)node;
        String prefix = context.getDialectPrefix();
        if (!attributeHolderNode.hasNormalizedAttribute(prefix, this.attributeName)) {
            return false;
        }
        if (this.elementNameFilter != null) {
            if (attributeHolderNode instanceof Element) {
                Element element = (Element)attributeHolderNode;
                if (!element.getNormalizedName().equals(this.elementNameFilter)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (this.attributeValuesByNameFilter != null) {
            for (Map.Entry<String, String> filterAttributeEntry : this.attributeValuesByNameFilter.entrySet()) {
                String elementAttributeValue;
                String filterAttributeName = filterAttributeEntry.getKey();
                String filterAttributeValue = filterAttributeEntry.getValue();
                if (!(!attributeHolderNode.hasAttribute(filterAttributeName) ? filterAttributeValue != null : ((elementAttributeValue = attributeHolderNode.getAttributeValue(filterAttributeName)) == null ? filterAttributeValue != null : !elementAttributeValue.equals(filterAttributeValue)))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Class<? extends NestableAttributeHolderNode> appliesTo() {
        return NestableAttributeHolderNode.class;
    }
}

