/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client.file.options;

import tachyon.client.ClientContext;
import tachyon.client.UnderStorageType;
import tachyon.client.WriteType;
import tachyon.conf.TachyonConf;
import tachyon.thrift.CreateTOptions;

public final class CreateOptions {
    private final long mBlockSizeBytes;
    private final boolean mRecursive;
    private final long mTTL;
    private final UnderStorageType mUnderStorageType;

    public static CreateOptions defaults() {
        return new Builder(ClientContext.getConf()).build();
    }

    private CreateOptions(Builder builder) {
        this.mBlockSizeBytes = builder.mBlockSizeBytes;
        this.mRecursive = builder.mRecursive;
        this.mTTL = builder.mTTL;
        this.mUnderStorageType = builder.mUnderStorageType;
    }

    public long getBlockSizeBytes() {
        return this.mBlockSizeBytes;
    }

    public boolean isRecursive() {
        return this.mRecursive;
    }

    public long getTTL() {
        return this.mTTL;
    }

    public UnderStorageType getUnderStorageType() {
        return this.mUnderStorageType;
    }

    public CreateTOptions toThrift() {
        CreateTOptions options = new CreateTOptions();
        options.setBlockSizeBytes(this.mBlockSizeBytes);
        options.setPersisted(this.mUnderStorageType.isSyncPersist());
        options.setRecursive(this.mRecursive);
        options.setTtl(this.mTTL);
        return options;
    }

    public static class Builder {
        private long mBlockSizeBytes;
        private boolean mRecursive;
        private long mTTL;
        private UnderStorageType mUnderStorageType;

        public Builder(TachyonConf conf) {
            this.mBlockSizeBytes = conf.getBytes("tachyon.user.block.size.bytes.default");
            this.mRecursive = false;
            this.mTTL = -1L;
            WriteType defaultWriteType = conf.getEnum("tachyon.user.file.writetype.default", WriteType.class);
            this.mUnderStorageType = defaultWriteType.getUnderStorageType();
        }

        public Builder setBlockSizeBytes(long blockSizeBytes) {
            this.mBlockSizeBytes = blockSizeBytes;
            return this;
        }

        public Builder setRecursive(boolean recursive) {
            this.mRecursive = recursive;
            return this;
        }

        public Builder setTTL(long ttl) {
            this.mTTL = ttl;
            return this;
        }

        public Builder setUnderStorageType(UnderStorageType underStorageType) {
            this.mUnderStorageType = underStorageType;
            return this;
        }

        public Builder setWriteType(WriteType writeType) {
            this.mUnderStorageType = writeType.getUnderStorageType();
            return this;
        }

        public CreateOptions build() {
            return new CreateOptions(this);
        }
    }
}

