/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.script;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.core.NamedThreadLocal;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.scripting.support.StandardScriptEvalException;
import org.springframework.scripting.support.StandardScriptUtils;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.view.AbstractUrlBasedView;
import org.springframework.web.servlet.view.script.ScriptTemplateConfig;

public class ScriptTemplateView
extends AbstractUrlBasedView {
    public static final String DEFAULT_CONTENT_TYPE = "text/html";
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static final String DEFAULT_RESOURCE_LOADER_PATH = "classpath:";
    private static final ThreadLocal<Map<Object, ScriptEngine>> enginesHolder = new NamedThreadLocal("ScriptTemplateView engines");
    private ScriptEngine engine;
    private String engineName;
    private Boolean sharedEngine;
    private String[] scripts;
    private String renderObject;
    private String renderFunction;
    private Charset charset;
    private String[] resourceLoaderPaths;
    private ResourceLoader resourceLoader;
    private volatile ScriptEngineManager scriptEngineManager;

    public ScriptTemplateView() {
        this.setContentType(null);
    }

    public ScriptTemplateView(String url) {
        super(url);
        this.setContentType(null);
    }

    public void setEngine(ScriptEngine engine) {
        Assert.isInstanceOf(Invocable.class, (Object)engine);
        this.engine = engine;
    }

    public void setEngineName(String engineName) {
        this.engineName = engineName;
    }

    public void setSharedEngine(Boolean sharedEngine) {
        this.sharedEngine = sharedEngine;
    }

    public void setScripts(String ... scripts) {
        this.scripts = scripts;
    }

    public void setRenderObject(String renderObject) {
        this.renderObject = renderObject;
    }

    public void setRenderFunction(String functionName) {
        this.renderFunction = functionName;
    }

    @Override
    public void setContentType(String contentType) {
        super.setContentType(contentType);
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void setResourceLoaderPath(String resourceLoaderPath) {
        String[] paths = StringUtils.commaDelimitedListToStringArray((String)resourceLoaderPath);
        this.resourceLoaderPaths = new String[paths.length + 1];
        this.resourceLoaderPaths[0] = "";
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            if (!path.endsWith("/") && !path.endsWith(":")) {
                path = path + "/";
            }
            this.resourceLoaderPaths[i + 1] = path;
        }
    }

    protected void initApplicationContext(ApplicationContext context) {
        super.initApplicationContext(context);
        ScriptTemplateConfig viewConfig = this.autodetectViewConfig();
        if (this.engine == null && viewConfig.getEngine() != null) {
            this.setEngine(viewConfig.getEngine());
        }
        if (this.engineName == null && viewConfig.getEngineName() != null) {
            this.engineName = viewConfig.getEngineName();
        }
        if (this.scripts == null && viewConfig.getScripts() != null) {
            this.scripts = viewConfig.getScripts();
        }
        if (this.renderObject == null && viewConfig.getRenderObject() != null) {
            this.renderObject = viewConfig.getRenderObject();
        }
        if (this.renderFunction == null && viewConfig.getRenderFunction() != null) {
            this.renderFunction = viewConfig.getRenderFunction();
        }
        if (this.getContentType() == null) {
            this.setContentType(viewConfig.getContentType() != null ? viewConfig.getContentType() : DEFAULT_CONTENT_TYPE);
        }
        if (this.charset == null) {
            Charset charset = this.charset = viewConfig.getCharset() != null ? viewConfig.getCharset() : DEFAULT_CHARSET;
        }
        if (this.resourceLoaderPaths == null) {
            String resourceLoaderPath = viewConfig.getResourceLoaderPath();
            this.setResourceLoaderPath(resourceLoaderPath == null ? DEFAULT_RESOURCE_LOADER_PATH : resourceLoaderPath);
        }
        if (this.resourceLoader == null) {
            this.resourceLoader = this.getApplicationContext();
        }
        if (this.sharedEngine == null && viewConfig.isSharedEngine() != null) {
            this.sharedEngine = viewConfig.isSharedEngine();
        }
        Assert.isTrue((this.engine == null || this.engineName == null ? 1 : 0) != 0, (String)"You should define either 'engine' or 'engineName', not both.");
        Assert.isTrue((this.engine != null || this.engineName != null ? 1 : 0) != 0, (String)"No script engine found, please specify either 'engine' or 'engineName'.");
        if (Boolean.FALSE.equals(this.sharedEngine)) {
            Assert.isTrue((this.engineName != null ? 1 : 0) != 0, (String)"When 'sharedEngine' is set to false, you should specify the script engine using the 'engineName' property, not the 'engine' one.");
        } else if (this.engine != null) {
            this.loadScripts(this.engine);
        } else {
            this.setEngine(this.createEngineFromName());
        }
        Assert.isTrue((this.renderFunction != null ? 1 : 0) != 0, (String)"The 'renderFunction' property must be defined.");
    }

    protected ScriptEngine getEngine() {
        if (Boolean.FALSE.equals(this.sharedEngine)) {
            Object engineKey;
            ScriptEngine engine;
            Map<Object, ScriptEngine> engines = enginesHolder.get();
            if (engines == null) {
                engines = new HashMap<Object, ScriptEngine>(4);
                enginesHolder.set(engines);
            }
            if ((engine = engines.get(engineKey = !ObjectUtils.isEmpty((Object[])this.scripts) ? new EngineKey(this.engineName, this.scripts) : this.engineName)) == null) {
                engine = this.createEngineFromName();
                engines.put(engineKey, engine);
            }
            return engine;
        }
        return this.engine;
    }

    protected ScriptEngine createEngineFromName() {
        if (this.scriptEngineManager == null) {
            this.scriptEngineManager = new ScriptEngineManager(this.getApplicationContext().getClassLoader());
        }
        ScriptEngine engine = StandardScriptUtils.retrieveEngineByName((ScriptEngineManager)this.scriptEngineManager, (String)this.engineName);
        this.loadScripts(engine);
        return engine;
    }

    protected void loadScripts(ScriptEngine engine) {
        if (!ObjectUtils.isEmpty((Object[])this.scripts)) {
            try {
                for (String script : this.scripts) {
                    Resource resource = this.getResource(script);
                    engine.eval(new InputStreamReader(resource.getInputStream()));
                }
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to load script", ex);
            }
        }
    }

    protected Resource getResource(String location) {
        for (String path : this.resourceLoaderPaths) {
            Resource resource = this.resourceLoader.getResource(path + location);
            if (!resource.exists()) continue;
            return resource;
        }
        throw new IllegalStateException("Resource [" + location + "] not found");
    }

    protected ScriptTemplateConfig autodetectViewConfig() throws BeansException {
        try {
            return (ScriptTemplateConfig)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.getApplicationContext(), ScriptTemplateConfig.class, (boolean)true, (boolean)false);
        }
        catch (NoSuchBeanDefinitionException ex) {
            throw new ApplicationContextException("Expected a single ScriptTemplateConfig bean in the current Servlet web application context or the parent root context: ScriptTemplateConfigurer is the usual implementation. This bean may have any name.", (Throwable)ex);
        }
    }

    @Override
    protected void prepareResponse(HttpServletRequest request, HttpServletResponse response) {
        super.prepareResponse(request, response);
        this.setResponseContentType(request, response);
        response.setCharacterEncoding(this.charset.name());
    }

    @Override
    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Object html;
            ScriptEngine engine = this.getEngine();
            Invocable invocable = (Invocable)((Object)engine);
            String url = this.getUrl();
            String template = this.getTemplate(url);
            if (this.renderObject != null) {
                Object thiz = engine.eval(this.renderObject);
                html = invocable.invokeMethod(thiz, this.renderFunction, template, model, url);
            } else {
                html = invocable.invokeFunction(this.renderFunction, template, model, url);
            }
            response.getWriter().write(String.valueOf(html));
        }
        catch (ScriptException ex) {
            throw new ServletException("Failed to render script template", (Throwable)new StandardScriptEvalException(ex));
        }
    }

    protected String getTemplate(String path) throws IOException {
        Resource resource = this.getResource(path);
        InputStreamReader reader = new InputStreamReader(resource.getInputStream(), this.charset);
        return FileCopyUtils.copyToString((Reader)reader);
    }

    private static class EngineKey {
        private final String engineName;
        private final String[] scripts;

        public EngineKey(String engineName, String[] scripts) {
            this.engineName = engineName;
            this.scripts = scripts;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EngineKey)) {
                return false;
            }
            EngineKey otherKey = (EngineKey)other;
            return this.engineName.equals(otherKey.engineName) && Arrays.equals(this.scripts, otherKey.scripts);
        }

        public int hashCode() {
            return this.engineName.hashCode() * 29 + Arrays.hashCode(this.scripts);
        }
    }
}

