/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bson.BSONObject;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.FieldsExposingAggregationOperation;
import org.springframework.data.mongodb.core.aggregation.SpelExpressionTransformer;
import org.springframework.util.Assert;

public class ProjectionOperation
implements FieldsExposingAggregationOperation {
    private static final List<Projection> NONE = Collections.emptyList();
    private static final String EXCLUSION_ERROR = "Exclusion of field %s not allowed. Projections by the mongodb aggregation framework only support the exclusion of the %s field!";
    private final List<Projection> projections;

    public ProjectionOperation() {
        this(NONE, NONE);
    }

    public ProjectionOperation(Fields fields) {
        this(NONE, ProjectionOperationBuilder.FieldProjection.from(fields));
    }

    private ProjectionOperation(List<? extends Projection> current, List<? extends Projection> projections) {
        Assert.notNull(current, (String)"Current projections must not be null!");
        Assert.notNull(projections, (String)"Projections must not be null!");
        this.projections = new ArrayList<Projection>(current.size() + projections.size());
        this.projections.addAll(current);
        this.projections.addAll(projections);
    }

    private ProjectionOperation and(Projection projection) {
        return new ProjectionOperation(this.projections, Arrays.asList(projection));
    }

    private ProjectionOperation andReplaceLastOneWith(Projection projection) {
        List projections = this.projections.isEmpty() ? Collections.emptyList() : this.projections.subList(0, this.projections.size() - 1);
        return new ProjectionOperation(projections, Arrays.asList(projection));
    }

    public ProjectionOperationBuilder and(String name) {
        return new ProjectionOperationBuilder(name, this, null);
    }

    public ExpressionProjectionOperationBuilder andExpression(String expression, Object ... params) {
        return new ExpressionProjectionOperationBuilder(expression, this, params);
    }

    public ProjectionOperationBuilder and(AggregationExpression expression) {
        return new ProjectionOperationBuilder(expression, this, null);
    }

    public ProjectionOperation andExclude(String ... fieldNames) {
        for (String fieldName : fieldNames) {
            Assert.isTrue((boolean)"_id".equals(fieldName), (String)String.format(EXCLUSION_ERROR, fieldName, "_id"));
        }
        List<ProjectionOperationBuilder.FieldProjection> excludeProjections = ProjectionOperationBuilder.FieldProjection.from(Fields.fields(fieldNames), false);
        return new ProjectionOperation(this.projections, excludeProjections);
    }

    public ProjectionOperation andInclude(String ... fieldNames) {
        List<ProjectionOperationBuilder.FieldProjection> projections = ProjectionOperationBuilder.FieldProjection.from(Fields.fields(fieldNames), true);
        return new ProjectionOperation(this.projections, projections);
    }

    public ProjectionOperation andInclude(Fields fields) {
        return new ProjectionOperation(this.projections, ProjectionOperationBuilder.FieldProjection.from(fields, true));
    }

    @Override
    public ExposedFields getFields() {
        ExposedFields fields = null;
        for (Projection projection : this.projections) {
            ExposedFields.ExposedField field = projection.getExposedField();
            fields = fields == null ? ExposedFields.from(field) : fields.and(field);
        }
        return fields;
    }

    @Override
    public DBObject toDBObject(AggregationOperationContext context) {
        BasicDBObject fieldObject = new BasicDBObject();
        for (Projection projection : this.projections) {
            fieldObject.putAll((BSONObject)projection.toDBObject(context));
        }
        return new BasicDBObject("$project", (Object)fieldObject);
    }

    static class ExpressionProjection
    extends Projection {
        private final AggregationExpression expression;
        private final Field field;

        public ExpressionProjection(Field field, AggregationExpression expression) {
            super(field);
            this.field = field;
            this.expression = expression;
        }

        @Override
        public DBObject toDBObject(AggregationOperationContext context) {
            return new BasicDBObject(this.field.getName(), (Object)this.expression.toDbObject(context));
        }
    }

    private static abstract class Projection {
        private final ExposedFields.ExposedField field;

        public Projection(Field field) {
            Assert.notNull((Object)field, (String)"Field must not be null!");
            this.field = new ExposedFields.ExposedField(field, true);
        }

        public ExposedFields.ExposedField getExposedField() {
            return this.field;
        }

        public abstract DBObject toDBObject(AggregationOperationContext var1);
    }

    public static class ProjectionOperationBuilder
    extends AbstractProjectionOperationBuilder {
        private static final String NUMBER_NOT_NULL = "Number must not be null!";
        private static final String FIELD_REFERENCE_NOT_NULL = "Field reference must not be null!";
        private final String name;
        private final OperationProjection previousProjection;

        public ProjectionOperationBuilder(String name, ProjectionOperation operation, OperationProjection previousProjection) {
            super(name, operation);
            this.name = name;
            this.previousProjection = previousProjection;
        }

        protected ProjectionOperationBuilder(Object value, ProjectionOperation operation, OperationProjection previousProjection) {
            super(value, operation);
            this.name = null;
            this.previousProjection = previousProjection;
        }

        public ProjectionOperation previousOperation() {
            return this.operation.andExclude("_id").and(new PreviousOperationProjection(this.name));
        }

        public ProjectionOperation nested(Fields fields) {
            return this.operation.and(new NestedFieldProjection(this.name, fields));
        }

        @Override
        public ProjectionOperation as(String alias) {
            if (this.previousProjection != null) {
                return this.operation.andReplaceLastOneWith(this.previousProjection.withAlias(alias));
            }
            if (this.value instanceof AggregationExpression) {
                return this.operation.and(new ExpressionProjection(Fields.field(alias), (AggregationExpression)this.value));
            }
            return this.operation.and(new FieldProjection(Fields.field(alias, this.name), null));
        }

        public ProjectionOperationBuilder plus(Number number) {
            Assert.notNull((Object)number, (String)NUMBER_NOT_NULL);
            return this.project("add", number);
        }

        public ProjectionOperationBuilder plus(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)FIELD_REFERENCE_NOT_NULL);
            return this.project("add", Fields.field(fieldReference));
        }

        public ProjectionOperationBuilder minus(Number number) {
            Assert.notNull((Object)number, (String)NUMBER_NOT_NULL);
            return this.project("subtract", number);
        }

        public ProjectionOperationBuilder minus(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)FIELD_REFERENCE_NOT_NULL);
            return this.project("subtract", Fields.field(fieldReference));
        }

        public ProjectionOperationBuilder multiply(Number number) {
            Assert.notNull((Object)number, (String)NUMBER_NOT_NULL);
            return this.project("multiply", number);
        }

        public ProjectionOperationBuilder multiply(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)FIELD_REFERENCE_NOT_NULL);
            return this.project("multiply", Fields.field(fieldReference));
        }

        public ProjectionOperationBuilder divide(Number number) {
            Assert.notNull((Object)number, (String)FIELD_REFERENCE_NOT_NULL);
            Assert.isTrue((Math.abs(number.intValue()) != 0 ? 1 : 0) != 0, (String)"Number must not be zero!");
            return this.project("divide", number);
        }

        public ProjectionOperationBuilder divide(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)FIELD_REFERENCE_NOT_NULL);
            return this.project("divide", Fields.field(fieldReference));
        }

        public ProjectionOperationBuilder mod(Number number) {
            Assert.notNull((Object)number, (String)NUMBER_NOT_NULL);
            Assert.isTrue((Math.abs(number.intValue()) != 0 ? 1 : 0) != 0, (String)"Number must not be zero!");
            return this.project("mod", number);
        }

        public ProjectionOperationBuilder mod(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)FIELD_REFERENCE_NOT_NULL);
            return this.project("mod", Fields.field(fieldReference));
        }

        public ProjectionOperationBuilder size() {
            return this.project("size", new Object[0]);
        }

        @Override
        public DBObject toDBObject(AggregationOperationContext context) {
            return this.operation.toDBObject(context);
        }

        public ProjectionOperationBuilder project(String operation, Object ... values) {
            OperationProjection operationProjection = new OperationProjection(Fields.field(this.value.toString()), operation, values);
            return new ProjectionOperationBuilder(this.value, this.operation.and(operationProjection), operationProjection);
        }

        public ProjectionOperationBuilder extractMinute() {
            return this.project("minute", new Object[0]);
        }

        public ProjectionOperationBuilder extractHour() {
            return this.project("hour", new Object[0]);
        }

        public ProjectionOperationBuilder extractSecond() {
            return this.project("second", new Object[0]);
        }

        public ProjectionOperationBuilder extractMillisecond() {
            return this.project("millisecond", new Object[0]);
        }

        public ProjectionOperationBuilder extractYear() {
            return this.project("year", new Object[0]);
        }

        public ProjectionOperationBuilder extractMonth() {
            return this.project("month", new Object[0]);
        }

        public ProjectionOperationBuilder extractWeek() {
            return this.project("week", new Object[0]);
        }

        public ProjectionOperationBuilder extractDayOfYear() {
            return this.project("dayOfYear", new Object[0]);
        }

        public ProjectionOperationBuilder extractDayOfMonth() {
            return this.project("dayOfMonth", new Object[0]);
        }

        public ProjectionOperationBuilder extractDayOfWeek() {
            return this.project("dayOfWeek", new Object[0]);
        }

        static class NestedFieldProjection
        extends Projection {
            private final String name;
            private final Fields fields;

            public NestedFieldProjection(String name, Fields fields) {
                super(Fields.field(name));
                this.name = name;
                this.fields = fields;
            }

            @Override
            public DBObject toDBObject(AggregationOperationContext context) {
                BasicDBObject nestedObject = new BasicDBObject();
                for (Field field : this.fields) {
                    nestedObject.put(field.getName(), (Object)context.getReference(field.getTarget()).toString());
                }
                return new BasicDBObject(this.name, (Object)nestedObject);
            }
        }

        static class OperationProjection
        extends Projection {
            private final Field field;
            private final String operation;
            private final List<Object> values;

            public OperationProjection(Field field, String operation, Object[] values) {
                super(field);
                Assert.hasText((String)operation, (String)"Operation must not be null or empty!");
                Assert.notNull((Object)values, (String)"Values must not be null!");
                this.field = field;
                this.operation = operation;
                this.values = Arrays.asList(values);
            }

            @Override
            public DBObject toDBObject(AggregationOperationContext context) {
                BasicDBObject inner = new BasicDBObject("$" + this.operation, this.getOperationArguments(context));
                return new BasicDBObject(this.getField().getName(), (Object)inner);
            }

            protected List<Object> getOperationArguments(AggregationOperationContext context) {
                ArrayList<Object> result = new ArrayList<Object>(this.values.size());
                result.add(context.getReference(this.getField().getName()).toString());
                for (Object element : this.values) {
                    result.add(element instanceof Field ? context.getReference((Field)element).toString() : element);
                }
                return result;
            }

            protected Field getField() {
                return this.field;
            }

            @Override
            public ExposedFields.ExposedField getExposedField() {
                if (!this.getField().isAliased()) {
                    return super.getExposedField();
                }
                return new ExposedFields.ExposedField(new Fields.AggregationField(this.getField().getName()), true);
            }

            public OperationProjection withAlias(String alias) {
                final Field aliasedField = Fields.field(alias, this.field.getName());
                return new OperationProjection(aliasedField, this.operation, this.values.toArray()){

                    @Override
                    protected Field getField() {
                        return aliasedField;
                    }

                    @Override
                    protected List<Object> getOperationArguments(AggregationOperationContext context) {
                        return OperationProjection.this.getOperationArguments(context);
                    }
                };
            }
        }

        static class FieldProjection
        extends Projection {
            private final Field field;
            private final Object value;

            public FieldProjection(String name, Object value) {
                this(Fields.field(name), value);
            }

            private FieldProjection(Field field, Object value) {
                super(field);
                this.field = field;
                this.value = value;
            }

            public static List<? extends Projection> from(Fields fields) {
                return FieldProjection.from(fields, null);
            }

            public static List<FieldProjection> from(Fields fields, Object value) {
                Assert.notNull((Object)fields, (String)"Fields must not be null!");
                ArrayList<FieldProjection> projections = new ArrayList<FieldProjection>();
                for (Field field : fields) {
                    projections.add(new FieldProjection(field, value));
                }
                return projections;
            }

            @Override
            public DBObject toDBObject(AggregationOperationContext context) {
                return new BasicDBObject(this.field.getName(), this.renderFieldValue(context));
            }

            private Object renderFieldValue(AggregationOperationContext context) {
                if (this.value == null || Boolean.TRUE.equals(this.value)) {
                    if (Aggregation.SystemVariable.isReferingToSystemVariable(this.field.getTarget())) {
                        return this.field.getTarget();
                    }
                    return context.getReference(this.field).getReferenceValue();
                }
                if (Boolean.FALSE.equals(this.value)) {
                    return 0;
                }
                return this.value;
            }
        }

        static class PreviousOperationProjection
        extends Projection {
            private final String name;

            public PreviousOperationProjection(String name) {
                super(Fields.field(name));
                this.name = name;
            }

            @Override
            public DBObject toDBObject(AggregationOperationContext context) {
                return new BasicDBObject(this.name, (Object)"$_id");
            }
        }
    }

    public static class ExpressionProjectionOperationBuilder
    extends ProjectionOperationBuilder {
        private final Object[] params;
        private final String expression;

        public ExpressionProjectionOperationBuilder(String expression, ProjectionOperation operation, Object[] parameters) {
            super(expression, operation, null);
            this.expression = expression;
            this.params = (Object[])parameters.clone();
        }

        @Override
        public ProjectionOperationBuilder project(String operation, final Object ... values) {
            ProjectionOperationBuilder.OperationProjection operationProjection = new ProjectionOperationBuilder.OperationProjection(Fields.field(this.value.toString()), operation, values){

                @Override
                protected List<Object> getOperationArguments(AggregationOperationContext context) {
                    ArrayList<Object> result = new ArrayList<Object>(values.length + 1);
                    result.add(ExpressionProjection.toMongoExpression(context, ExpressionProjectionOperationBuilder.this.expression, ExpressionProjectionOperationBuilder.this.params));
                    result.addAll(Arrays.asList(values));
                    return result;
                }
            };
            return new ProjectionOperationBuilder(this.value, this.operation.and(operationProjection), operationProjection);
        }

        @Override
        public ProjectionOperation as(String alias) {
            Field expressionField = Fields.field(alias, alias);
            return this.operation.and(new ExpressionProjection(expressionField, this.value.toString(), this.params));
        }

        static class ExpressionProjection
        extends Projection {
            private static final SpelExpressionTransformer TRANSFORMER = new SpelExpressionTransformer();
            private final String expression;
            private final Object[] params;

            public ExpressionProjection(Field field, String expression, Object[] parameters) {
                super(field);
                Assert.hasText((String)expression, (String)"Expression must not be null!");
                Assert.notNull((Object)parameters, (String)"Parameters must not be null!");
                this.expression = expression;
                this.params = (Object[])parameters.clone();
            }

            @Override
            public DBObject toDBObject(AggregationOperationContext context) {
                return new BasicDBObject(this.getExposedField().getName(), ExpressionProjection.toMongoExpression(context, this.expression, this.params));
            }

            protected static Object toMongoExpression(AggregationOperationContext context, String expression, Object[] params) {
                return TRANSFORMER.transform(expression, context, params);
            }
        }
    }

    private static abstract class AbstractProjectionOperationBuilder
    implements AggregationOperation {
        protected final Object value;
        protected final ProjectionOperation operation;

        public AbstractProjectionOperationBuilder(Object value, ProjectionOperation operation) {
            Assert.notNull((Object)value, (String)"value must not be null or empty!");
            Assert.notNull((Object)operation, (String)"ProjectionOperation must not be null!");
            this.value = value;
            this.operation = operation;
        }

        @Override
        public DBObject toDBObject(AggregationOperationContext context) {
            return this.operation.toDBObject(context);
        }

        public abstract ProjectionOperation as(String var1);
    }
}

