/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.core.io.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.aws.core.io.s3.SimpleStorageNameUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;

public class PathMatchingSimpleStorageResourcePatternResolver
implements ResourcePatternResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(PathMatchingSimpleStorageResourcePatternResolver.class);
    private final AmazonS3 amazonS3;
    private final ResourceLoader simpleStorageResourceLoader;
    private final ResourcePatternResolver resourcePatternResolverDelegate;
    private PathMatcher pathMatcher = new AntPathMatcher();

    public PathMatchingSimpleStorageResourcePatternResolver(AmazonS3 amazonS3, ResourceLoader simpleStorageResourceLoader, ResourcePatternResolver resourcePatternResolverDelegate) {
        Assert.notNull((Object)amazonS3);
        this.amazonS3 = amazonS3;
        this.simpleStorageResourceLoader = simpleStorageResourceLoader;
        this.resourcePatternResolverDelegate = resourcePatternResolverDelegate;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        Assert.notNull((Object)pathMatcher, (String)"PathMatcher must not be null");
        this.pathMatcher = pathMatcher;
    }

    public Resource[] getResources(String locationPattern) throws IOException {
        if (SimpleStorageNameUtils.isSimpleStorageResource(locationPattern)) {
            if (this.pathMatcher.isPattern(SimpleStorageNameUtils.stripProtocol(locationPattern))) {
                LOGGER.debug("Found wildcard pattern in location {}", (Object)locationPattern);
                return this.findPathMatchingResources(locationPattern);
            }
            return new Resource[]{this.simpleStorageResourceLoader.getResource(locationPattern)};
        }
        return this.resourcePatternResolverDelegate.getResources(locationPattern);
    }

    protected Resource[] findPathMatchingResources(String locationPattern) {
        Set<Resource> resources;
        String bucketPattern = SimpleStorageNameUtils.getBucketNameFromLocation(locationPattern);
        String keyPattern = SimpleStorageNameUtils.getObjectNameFromLocation(locationPattern);
        if (this.pathMatcher.isPattern(bucketPattern)) {
            List<String> matchingBuckets = this.findMatchingBuckets(bucketPattern);
            LOGGER.debug("Found wildcard in bucket name {} buckets found are {}", (Object)bucketPattern, matchingBuckets);
            if (bucketPattern.startsWith("**")) {
                keyPattern = "**/" + keyPattern;
            }
            resources = this.findPathMatchingKeys(keyPattern, matchingBuckets);
            LOGGER.debug("Found resources {} in buckets {}", resources, matchingBuckets);
        } else {
            LOGGER.debug("No wildcard in bucket name {} using single bucket name", (Object)bucketPattern);
            resources = this.findPathMatchingKeys(keyPattern, Arrays.asList(bucketPattern));
        }
        return resources.toArray(new Resource[resources.size()]);
    }

    private Set<Resource> findPathMatchingKeys(String keyPattern, List<String> matchingBuckets) {
        HashSet<Resource> resources = new HashSet<Resource>();
        if (this.pathMatcher.isPattern(keyPattern)) {
            for (String bucketName : matchingBuckets) {
                this.findPathMatchingKeyInBucket(bucketName, resources, null, keyPattern);
            }
        } else {
            for (String matchingBucket : matchingBuckets) {
                Resource resource = this.simpleStorageResourceLoader.getResource(SimpleStorageNameUtils.getLocationForBucketAndObject(matchingBucket, keyPattern));
                if (!resource.exists()) continue;
                resources.add(resource);
            }
        }
        return resources;
    }

    private void findPathMatchingKeyInBucket(String bucketName, Set<Resource> resources, String prefix, String keyPattern) {
        String remainingPatternPart = this.getRemainingPatternPart(keyPattern, prefix);
        if (remainingPatternPart.startsWith("**")) {
            this.findAllResourcesThatMatches(bucketName, resources, prefix, keyPattern);
        } else {
            this.findProgressivelyWithPartialMatch(bucketName, resources, prefix, keyPattern);
        }
    }

    private void findAllResourcesThatMatches(String bucketName, Set<Resource> resources, String prefix, String keyPattern) {
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(bucketName).withPrefix(prefix);
        ObjectListing objectListing = null;
        do {
            try {
                objectListing = objectListing == null ? this.amazonS3.listObjects(listObjectsRequest) : this.amazonS3.listNextBatchOfObjects(objectListing);
                Set<Resource> newResources = this.getResourcesFromObjectSummaries(bucketName, keyPattern, objectListing.getObjectSummaries());
                if (newResources.isEmpty()) continue;
                resources.addAll(newResources);
            }
            catch (AmazonS3Exception e) {
                if (301 == e.getStatusCode()) continue;
                throw e;
            }
        } while (objectListing != null && objectListing.isTruncated());
    }

    private void findProgressivelyWithPartialMatch(String bucketName, Set<Resource> resources, String prefix, String keyPattern) {
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(bucketName).withDelimiter("/").withPrefix(prefix);
        ObjectListing objectListing = null;
        do {
            Set<Resource> newResources;
            if (!(newResources = this.getResourcesFromObjectSummaries(bucketName, keyPattern, (objectListing = objectListing == null ? this.amazonS3.listObjects(listObjectsRequest) : this.amazonS3.listNextBatchOfObjects(objectListing)).getObjectSummaries())).isEmpty()) {
                resources.addAll(newResources);
            }
            for (String commonPrefix : objectListing.getCommonPrefixes()) {
                if (!this.isKeyPathMatchesPartially(keyPattern, commonPrefix)) continue;
                this.findPathMatchingKeyInBucket(bucketName, resources, commonPrefix, keyPattern);
            }
        } while (objectListing.isTruncated());
    }

    private String getRemainingPatternPart(String keyPattern, String path) {
        int numberOfSlashes = StringUtils.countOccurrencesOf((String)path, (String)"/");
        int indexOfNthSlash = this.getIndexOfNthOccurrence(keyPattern, "/", numberOfSlashes);
        return indexOfNthSlash == -1 ? null : keyPattern.substring(indexOfNthSlash);
    }

    private boolean isKeyPathMatchesPartially(String keyPattern, String keyPath) {
        int numberOfSlashes = StringUtils.countOccurrencesOf((String)keyPath, (String)"/");
        int indexOfNthSlash = this.getIndexOfNthOccurrence(keyPattern, "/", numberOfSlashes);
        if (indexOfNthSlash != -1) {
            return this.pathMatcher.match(keyPattern.substring(0, indexOfNthSlash), keyPath);
        }
        return false;
    }

    private int getIndexOfNthOccurrence(String str, String sub, int pos) {
        int result = 0;
        String subStr = str;
        for (int i = 0; i < pos; ++i) {
            int nthOccurrence = subStr.indexOf(sub);
            if (nthOccurrence == -1) {
                return -1;
            }
            result += nthOccurrence + 1;
            subStr = subStr.substring(nthOccurrence + 1);
        }
        return result;
    }

    private Set<Resource> getResourcesFromObjectSummaries(String bucketName, String keyPattern, List<S3ObjectSummary> objectSummaries) {
        HashSet<Resource> resources = new HashSet<Resource>();
        for (S3ObjectSummary objectSummary : objectSummaries) {
            Resource resource;
            String keyPath = SimpleStorageNameUtils.getLocationForBucketAndObject(bucketName, objectSummary.getKey());
            if (!this.pathMatcher.match(keyPattern, objectSummary.getKey()) || !(resource = this.simpleStorageResourceLoader.getResource(keyPath)).exists()) continue;
            resources.add(resource);
        }
        return resources;
    }

    private List<String> findMatchingBuckets(String bucketPattern) {
        List buckets = this.amazonS3.listBuckets();
        ArrayList<String> matchingBuckets = new ArrayList<String>();
        for (Bucket bucket : buckets) {
            this.amazonS3.getBucketLocation(bucket.getName());
            if (!this.pathMatcher.match(bucketPattern, bucket.getName())) continue;
            matchingBuckets.add(bucket.getName());
        }
        return matchingBuckets;
    }

    public Resource getResource(String location) {
        return this.simpleStorageResourceLoader.getResource(location);
    }

    public ClassLoader getClassLoader() {
        return this.simpleStorageResourceLoader.getClassLoader();
    }
}

