/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.core.env.stack.config;

import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.model.DescribeStacksRequest;
import com.amazonaws.services.cloudformation.model.DescribeStacksResult;
import com.amazonaws.services.cloudformation.model.Stack;
import com.amazonaws.services.cloudformation.model.Tag;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.cloud.aws.core.env.stack.config.StackNameProvider;

public class StackResourceUserTagsFactoryBean
extends AbstractFactoryBean<Map<String, String>> {
    private final AmazonCloudFormation amazonCloudFormation;
    private final StackNameProvider stackNameProvider;

    public StackResourceUserTagsFactoryBean(AmazonCloudFormation amazonCloudFormation, StackNameProvider stackNameProvider) {
        this.amazonCloudFormation = amazonCloudFormation;
        this.stackNameProvider = stackNameProvider;
    }

    public Class<?> getObjectType() {
        return Map.class;
    }

    protected Map<String, String> createInstance() throws Exception {
        LinkedHashMap<String, String> userTags = new LinkedHashMap<String, String>();
        DescribeStacksResult stacksResult = this.amazonCloudFormation.describeStacks(new DescribeStacksRequest().withStackName(this.stackNameProvider.getStackName()));
        for (Stack stack : stacksResult.getStacks()) {
            for (Tag tag : stack.getTags()) {
                userTags.put(tag.getKey(), tag.getValue());
            }
        }
        return userTags;
    }
}

