/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.core.env.stack.config;

import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.model.ListStackResourcesRequest;
import com.amazonaws.services.cloudformation.model.ListStackResourcesResult;
import com.amazonaws.services.cloudformation.model.StackResourceSummary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.cloud.aws.core.env.stack.ListableStackResourceFactory;
import org.springframework.cloud.aws.core.env.stack.StackResource;
import org.springframework.cloud.aws.core.env.stack.config.StackNameProvider;
import org.springframework.util.StringUtils;

public class StackResourceRegistryFactoryBean
extends AbstractFactoryBean<ListableStackResourceFactory> {
    private final AmazonCloudFormation amazonCloudFormationClient;
    private final StackNameProvider stackNameProvider;

    public StackResourceRegistryFactoryBean(AmazonCloudFormation amazonCloudFormationClient, StackNameProvider stackNameProvider) {
        this.amazonCloudFormationClient = amazonCloudFormationClient;
        this.stackNameProvider = stackNameProvider;
    }

    public Class<?> getObjectType() {
        return ListableStackResourceFactory.class;
    }

    protected ListableStackResourceFactory createInstance() throws Exception {
        String stackName = this.stackNameProvider.getStackName();
        return new StaticStackResourceRegistry(stackName, this.getResourceMappings("", stackName));
    }

    private Map<String, StackResource> getResourceMappings(String prefix, String stackName) {
        ListStackResourcesResult listStackResourcesResult = this.amazonCloudFormationClient.listStackResources(new ListStackResourcesRequest().withStackName(stackName));
        List stackResourceSummaries = listStackResourcesResult.getStackResourceSummaries();
        HashMap<String, StackResource> stackResourceMappings = new HashMap<String, StackResource>();
        Map<String, StackResource> current = this.convertToStackResourceMappings(prefix, stackResourceSummaries);
        stackResourceMappings.putAll(current);
        for (Map.Entry<String, StackResource> e : current.entrySet()) {
            StackResource resource = e.getValue();
            if (!"AWS::CloudFormation::Stack".equals(resource.getType())) continue;
            stackResourceMappings.putAll(this.getResourceMappings(e.getKey(), resource.getPhysicalId()));
        }
        return stackResourceMappings;
    }

    private Map<String, StackResource> convertToStackResourceMappings(String prefix, List<StackResourceSummary> stackResourceSummaries) {
        HashMap<String, StackResource> stackResourceMappings = new HashMap<String, StackResource>();
        for (StackResourceSummary stackResourceSummary : stackResourceSummaries) {
            String logicalResourceId = this.toNestedResourceId(prefix, stackResourceSummary.getLogicalResourceId());
            stackResourceMappings.put(logicalResourceId, new StackResource(logicalResourceId, stackResourceSummary.getPhysicalResourceId(), stackResourceSummary.getResourceType()));
        }
        return stackResourceMappings;
    }

    private String toNestedResourceId(String prefix, String logicalResourceId) {
        return StringUtils.isEmpty((Object)prefix) ? logicalResourceId : prefix + "." + logicalResourceId;
    }

    private static class StaticStackResourceRegistry
    implements ListableStackResourceFactory {
        private final String stackName;
        private final Map<String, StackResource> stackResourceByLogicalId;

        private StaticStackResourceRegistry(String stackName, Map<String, StackResource> stackResourceByLogicalId) {
            this.stackName = stackName;
            this.stackResourceByLogicalId = stackResourceByLogicalId;
        }

        @Override
        public String getStackName() {
            return this.stackName;
        }

        @Override
        public String lookupPhysicalResourceId(String logicalResourceId) {
            if (this.stackResourceByLogicalId.containsKey(logicalResourceId)) {
                return this.stackResourceByLogicalId.get(logicalResourceId).getPhysicalId();
            }
            if (!logicalResourceId.contains(".")) {
                String prefix = "." + logicalResourceId;
                String physicalId = null;
                for (Map.Entry<String, StackResource> entry : this.stackResourceByLogicalId.entrySet()) {
                    if (entry.getKey() == null || !entry.getKey().endsWith(prefix)) continue;
                    if (physicalId == null) {
                        physicalId = entry.getValue().getPhysicalId();
                        continue;
                    }
                    return null;
                }
                return physicalId;
            }
            return null;
        }

        @Override
        public Collection<StackResource> getAllResources() {
            return this.stackResourceByLogicalId.values();
        }

        @Override
        public Collection<StackResource> resourcesByType(String type) {
            ArrayList<StackResource> result = new ArrayList<StackResource>();
            for (StackResource stackResource : this.stackResourceByLogicalId.values()) {
                if (!stackResource.getType().equals(type)) continue;
                result.add(stackResource);
            }
            return result;
        }
    }
}

