/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.core.env.ec2;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeTagsRequest;
import com.amazonaws.services.ec2.model.DescribeTagsResult;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.TagDescription;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.cloud.aws.core.env.ec2.AmazonEc2InstanceIdProvider;
import org.springframework.cloud.aws.core.env.ec2.InstanceIdProvider;

public class AmazonEc2InstanceUserTagsFactoryBean
extends AbstractFactoryBean<Map<String, String>> {
    private final AmazonEC2 amazonEc2;
    private final InstanceIdProvider idProvider;

    public AmazonEc2InstanceUserTagsFactoryBean(AmazonEC2 amazonEc2) {
        this(amazonEc2, new AmazonEc2InstanceIdProvider());
    }

    public AmazonEc2InstanceUserTagsFactoryBean(AmazonEC2 amazonEc2, InstanceIdProvider idProvider) {
        this.amazonEc2 = amazonEc2;
        this.idProvider = idProvider;
    }

    public Class<?> getObjectType() {
        return Map.class;
    }

    protected Map<String, String> createInstance() throws Exception {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        DescribeTagsResult tags = this.amazonEc2.describeTags(new DescribeTagsRequest().withFilters(new Filter[]{new Filter("resource-id", Collections.singletonList(this.idProvider.getCurrentInstanceId())), new Filter("resource-type", Collections.singletonList("instance"))}));
        for (TagDescription tag : tags.getTags()) {
            properties.put(tag.getKey(), tag.getValue());
        }
        return properties;
    }
}

