/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;

class OrderedComposite<S> {
    private List<S> unordered = new ArrayList<S>();
    private List<S> ordered = new ArrayList<S>();
    private Comparator<? super S> comparator = new AnnotationAwareOrderComparator();
    private List<S> list = new ArrayList<S>();

    OrderedComposite() {
    }

    public void setItems(List<? extends S> items) {
        this.unordered.clear();
        this.ordered.clear();
        for (S s : items) {
            this.add(s);
        }
    }

    public void add(S item) {
        if (item instanceof Ordered) {
            if (!this.ordered.contains(item)) {
                this.ordered.add(item);
            }
        } else if (AnnotationUtils.isAnnotationDeclaredLocally(Order.class, item.getClass())) {
            if (!this.ordered.contains(item)) {
                this.ordered.add(item);
            }
        } else if (!this.unordered.contains(item)) {
            this.unordered.add(item);
        }
        Collections.sort(this.ordered, this.comparator);
        this.list.clear();
        this.list.addAll(this.ordered);
        this.list.addAll(this.unordered);
    }

    public Iterator<S> iterator() {
        return new ArrayList<S>(this.list).iterator();
    }

    public Iterator<S> reverse() {
        ArrayList<S> result = new ArrayList<S>(this.list);
        Collections.reverse(result);
        return result.iterator();
    }
}

