/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.jcache;

import java.lang.management.ManagementFactory;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.spi.CachingProvider;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.redisson.Redisson;
import org.redisson.jcache.JCache;
import org.redisson.jcache.bean.EmptyStatisticsMXBean;
import org.redisson.jcache.bean.JCacheManagementMXBean;
import org.redisson.jcache.bean.JCacheStatisticsMXBean;
import org.redisson.jcache.configuration.JCacheConfiguration;

public class JCacheManager
implements CacheManager {
    private static final EmptyStatisticsMXBean EMPTY_INSTANCE = new EmptyStatisticsMXBean();
    private static MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
    private final ClassLoader classLoader;
    private final CachingProvider cacheProvider;
    private final Properties properties;
    private final URI uri;
    private final ConcurrentMap<String, JCache<?, ?>> caches = new ConcurrentHashMap();
    private final ConcurrentMap<JCache<?, ?>, JCacheStatisticsMXBean> statBeans = new ConcurrentHashMap();
    private final ConcurrentMap<JCache<?, ?>, JCacheManagementMXBean> managementBeans = new ConcurrentHashMap();
    private volatile boolean closed;
    private final Redisson redisson;

    public JCacheManager(Redisson redisson, ClassLoader classLoader, CachingProvider cacheProvider, Properties properties, URI uri) {
        this.classLoader = classLoader;
        this.cacheProvider = cacheProvider;
        this.properties = properties;
        this.uri = uri;
        this.redisson = redisson;
    }

    public CachingProvider getCachingProvider() {
        return this.cacheProvider;
    }

    public URI getURI() {
        return this.uri;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Properties getProperties() {
        return this.properties;
    }

    private void checkNotClosed() {
        if (this.closed) {
            throw new IllegalStateException();
        }
    }

    public <K, V, C extends Configuration<K, V>> Cache<K, V> createCache(String cacheName, C configuration) throws IllegalArgumentException {
        this.checkNotClosed();
        if (cacheName == null) {
            throw new NullPointerException();
        }
        if (configuration == null) {
            throw new NullPointerException();
        }
        JCacheConfiguration cfg = new JCacheConfiguration(configuration);
        JCache cache = new JCache(this, this.redisson, cacheName, cfg);
        JCache oldCache = this.caches.putIfAbsent(cacheName, cache);
        if (oldCache != null) {
            throw new CacheException("Cache " + cacheName + " already exists");
        }
        if (cfg.isStatisticsEnabled()) {
            this.enableStatistics(cacheName, true);
        }
        if (cfg.isManagementEnabled()) {
            this.enableManagement(cacheName, true);
        }
        return cache;
    }

    public <K, V> Cache<K, V> getCache(String cacheName, Class<K> keyType, Class<V> valueType) {
        this.checkNotClosed();
        if (cacheName == null) {
            throw new NullPointerException();
        }
        if (keyType == null) {
            throw new NullPointerException();
        }
        if (valueType == null) {
            throw new NullPointerException();
        }
        JCache cache = (JCache)this.caches.get(cacheName);
        if (cache == null) {
            return null;
        }
        if (!keyType.isAssignableFrom(cache.getConfiguration(CompleteConfiguration.class).getKeyType())) {
            throw new ClassCastException("Wrong type of key for " + cacheName);
        }
        if (!valueType.isAssignableFrom(cache.getConfiguration(CompleteConfiguration.class).getValueType())) {
            throw new ClassCastException("Wrong type of value for " + cacheName);
        }
        return cache;
    }

    public <K, V> Cache<K, V> getCache(String cacheName) {
        this.checkNotClosed();
        Cache<Object, Object> cache = this.getCache(cacheName, Object.class, Object.class);
        if (cache != null) {
            if (((CompleteConfiguration)cache.getConfiguration(CompleteConfiguration.class)).getKeyType() != Object.class) {
                throw new IllegalArgumentException("Wrong type of key for " + cacheName);
            }
            if (((CompleteConfiguration)cache.getConfiguration(CompleteConfiguration.class)).getValueType() != Object.class) {
                throw new IllegalArgumentException("Wrong type of value for " + cacheName);
            }
        }
        return cache;
    }

    public Iterable<String> getCacheNames() {
        return Collections.unmodifiableSet(new HashSet(this.caches.keySet()));
    }

    public void destroyCache(String cacheName) {
        this.checkNotClosed();
        if (cacheName == null) {
            throw new NullPointerException();
        }
        JCache cache = (JCache)this.caches.get(cacheName);
        if (cache != null) {
            cache.clear();
            cache.close();
        }
    }

    public void closeCache(JCache<?, ?> cache) {
        this.caches.remove(cache.getName());
        this.unregisterStatisticsBean(cache);
        this.unregisterManagementBean(cache);
    }

    /*
     * Unable to fully structure code
     */
    public void enableManagement(String cacheName, boolean enabled) {
        this.checkNotClosed();
        if (cacheName == null) {
            throw new NullPointerException();
        }
        cache = (JCache)this.caches.get(cacheName);
        if (cache == null) {
            throw new NullPointerException();
        }
        if (enabled) {
            statBean = (JCacheManagementMXBean)this.managementBeans.get(cache);
            if (statBean == null && (oldBean = this.managementBeans.putIfAbsent(cache, statBean = new JCacheManagementMXBean(cache))) != null) {
                statBean = oldBean;
            }
            try {
                objectName = this.queryNames("Configuration", cache);
                if (!JCacheManager.mBeanServer.queryNames(objectName, null).isEmpty()) ** GOTO lbl26
                JCacheManager.mBeanServer.registerMBean(statBean, objectName);
            }
            catch (MalformedObjectNameException e) {
                throw new CacheException((Throwable)e);
            }
            catch (InstanceAlreadyExistsException e) {
                throw new CacheException((Throwable)e);
            }
            catch (MBeanRegistrationException e) {
                throw new CacheException((Throwable)e);
            }
            catch (NotCompliantMBeanException e) {
                throw new CacheException((Throwable)e);
            }
        } else {
            this.unregisterManagementBean(cache);
        }
lbl26:
        // 3 sources

        cache.getConfiguration(JCacheConfiguration.class).setManagementEnabled(enabled);
    }

    private ObjectName queryNames(String baseName, JCache<?, ?> cache) throws MalformedObjectNameException {
        String name = this.getName(baseName, cache);
        return new ObjectName(name);
    }

    private void unregisterManagementBean(JCache<?, ?> cache) {
        JCacheManagementMXBean statBean = (JCacheManagementMXBean)this.managementBeans.remove(cache);
        if (statBean != null) {
            try {
                ObjectName name = this.queryNames("Configuration", cache);
                for (ObjectName objectName : mBeanServer.queryNames(name, null)) {
                    mBeanServer.unregisterMBean(objectName);
                }
            }
            catch (MalformedObjectNameException e) {
                throw new CacheException((Throwable)e);
            }
            catch (MBeanRegistrationException e) {
                throw new CacheException((Throwable)e);
            }
            catch (InstanceNotFoundException e) {
                throw new CacheException((Throwable)e);
            }
        }
    }

    public JCacheStatisticsMXBean getStatBean(JCache<?, ?> cache) {
        JCacheStatisticsMXBean bean = (JCacheStatisticsMXBean)this.statBeans.get(cache);
        if (bean != null) {
            return bean;
        }
        return EMPTY_INSTANCE;
    }

    private String getName(String name, JCache<?, ?> cache) {
        return "javax.cache:type=Cache" + name + ",CacheManager=" + cache.getCacheManager().getURI().toString().replaceAll(",|:|=|\n", ".") + ",Cache=" + cache.getName().replaceAll(",|:|=|\n", ".");
    }

    /*
     * Unable to fully structure code
     */
    public void enableStatistics(String cacheName, boolean enabled) {
        this.checkNotClosed();
        if (cacheName == null) {
            throw new NullPointerException();
        }
        cache = (JCache)this.caches.get(cacheName);
        if (cache == null) {
            throw new NullPointerException();
        }
        if (enabled) {
            statBean = (JCacheStatisticsMXBean)this.statBeans.get(cache);
            if (statBean == null && (oldBean = this.statBeans.putIfAbsent(cache, statBean = new JCacheStatisticsMXBean())) != null) {
                statBean = oldBean;
            }
            try {
                objectName = this.queryNames("Statistics", cache);
                if (JCacheManager.mBeanServer.isRegistered(objectName)) ** GOTO lbl26
                JCacheManager.mBeanServer.registerMBean(statBean, objectName);
            }
            catch (MalformedObjectNameException e) {
                throw new CacheException((Throwable)e);
            }
            catch (InstanceAlreadyExistsException e) {
                throw new CacheException((Throwable)e);
            }
            catch (MBeanRegistrationException e) {
                throw new CacheException((Throwable)e);
            }
            catch (NotCompliantMBeanException e) {
                throw new CacheException((Throwable)e);
            }
        } else {
            this.unregisterStatisticsBean(cache);
        }
lbl26:
        // 3 sources

        cache.getConfiguration(JCacheConfiguration.class).setStatisticsEnabled(enabled);
    }

    private void unregisterStatisticsBean(JCache<?, ?> cache) {
        JCacheStatisticsMXBean statBean = (JCacheStatisticsMXBean)this.statBeans.remove(cache);
        if (statBean != null) {
            try {
                ObjectName name = this.queryNames("Statistics", cache);
                for (ObjectName objectName : mBeanServer.queryNames(name, null)) {
                    mBeanServer.unregisterMBean(objectName);
                }
            }
            catch (MalformedObjectNameException e) {
                throw new CacheException((Throwable)e);
            }
            catch (MBeanRegistrationException e) {
                throw new CacheException((Throwable)e);
            }
            catch (InstanceNotFoundException e) {
                throw new CacheException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.isClosed()) {
            return;
        }
        CachingProvider cachingProvider = this.cacheProvider;
        synchronized (cachingProvider) {
            if (!this.isClosed()) {
                this.cacheProvider.close(this.uri, this.classLoader);
                for (Cache cache : this.caches.values()) {
                    try {
                        cache.close();
                    }
                    catch (Exception e) {}
                }
                this.redisson.shutdown();
                this.closed = true;
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw new IllegalArgumentException();
    }
}

