/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.command;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.List;
import org.reactivestreams.Publisher;
import org.redisson.SlotCallback;
import org.redisson.api.RFuture;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.command.CommandAsyncService;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.reactive.NettyFuturePublisher;

public class CommandReactiveService
extends CommandAsyncService
implements CommandReactiveExecutor {
    public CommandReactiveService(ConnectionManager connectionManager) {
        super(connectionManager);
    }

    @Override
    public <T, R> Publisher<R> evalWriteAllReactive(RedisCommand<T> command, SlotCallback<T, R> callback, String script, List<Object> keys, Object ... params) {
        RFuture<R> f = this.evalWriteAllAsync(command, callback, script, keys, params);
        return new NettyFuturePublisher<R>(f);
    }

    @Override
    public <R> Publisher<R> reactive(RFuture<R> future) {
        return new NettyFuturePublisher<R>(future);
    }

    @Override
    public <T, R> Publisher<Collection<R>> readAllReactive(RedisCommand<T> command, Object ... params) {
        RFuture f = this.readAllAsync(command, params);
        return new NettyFuturePublisher(f);
    }

    @Override
    public <T, R> Publisher<R> readRandomReactive(RedisCommand<T> command, Object ... params) {
        RFuture f = this.readRandomAsync(command, params);
        return new NettyFuturePublisher(f);
    }

    @Override
    public <T, R> Publisher<R> readReactive(InetSocketAddress client, String key, Codec codec, RedisCommand<T> command, Object ... params) {
        RFuture f = this.readAsync(client, key, codec, command, params);
        return new NettyFuturePublisher(f);
    }

    @Override
    public <T, R> Publisher<R> writeReactive(String key, RedisCommand<T> command, Object ... params) {
        return this.writeReactive(key, this.connectionManager.getCodec(), command, params);
    }

    @Override
    public <T, R> Publisher<R> writeReactive(String key, Codec codec, RedisCommand<T> command, Object ... params) {
        RFuture f = this.writeAsync(key, codec, command, params);
        return new NettyFuturePublisher(f);
    }

    @Override
    public <T, R> Publisher<R> writeReactive(MasterSlaveEntry entry, Codec codec, RedisCommand<T> command, Object ... params) {
        RFuture f = this.writeAsync(entry, codec, command, params);
        return new NettyFuturePublisher(f);
    }

    @Override
    public <T, R> Publisher<R> readReactive(String key, RedisCommand<T> command, Object ... params) {
        return this.readReactive(key, this.connectionManager.getCodec(), command, params);
    }

    @Override
    public <T, R> Publisher<R> readReactive(String key, Codec codec, RedisCommand<T> command, Object ... params) {
        RFuture f = this.readAsync(key, codec, command, params);
        return new NettyFuturePublisher(f);
    }

    @Override
    public <T, R> Publisher<R> evalReadReactive(String key, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        RFuture f = this.evalReadAsync(key, codec, evalCommandType, script, keys, params);
        return new NettyFuturePublisher(f);
    }

    @Override
    public <T, R> Publisher<R> evalReadReactive(InetSocketAddress client, String key, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        RFuture f = this.evalReadAsync(client, key, codec, evalCommandType, script, keys, params);
        return new NettyFuturePublisher(f);
    }

    @Override
    public <T, R> Publisher<R> evalWriteReactive(String key, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        RFuture f = this.evalWriteAsync(key, codec, evalCommandType, script, keys, params);
        return new NettyFuturePublisher(f);
    }

    @Override
    public <T> Publisher<Void> writeAllReactive(RedisCommand<T> command, Object ... params) {
        RFuture<Void> f = this.writeAllAsync(command, params);
        return new NettyFuturePublisher<Void>(f);
    }

    @Override
    public <R, T> Publisher<R> writeAllReactive(RedisCommand<T> command, SlotCallback<T, R> callback, Object ... params) {
        RFuture<R> f = this.writeAllAsync(command, callback, params);
        return new NettyFuturePublisher<R>(f);
    }
}

