/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.util;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.xml.bind.DatatypeConverter;

public class KryoSerializationHelper {
    private final Kryo kryo;

    public KryoSerializationHelper() {
        this.kryo = new Kryo();
    }

    public KryoSerializationHelper(Kryo kryo) {
        this.kryo = kryo;
    }

    public String serializeToBase64(Serializable o) {
        return DatatypeConverter.printBase64Binary((byte[])this.serializeToBytes(o));
    }

    public byte[] serializeToBytes(Serializable o) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try (Output output = new Output((OutputStream)byteStream);){
            this.kryo.writeClassAndObject(output, (Object)o);
            output.flush();
            byte[] byArray = byteStream.toByteArray();
            return byArray;
        }
    }

    public Serializable unserializeFromBase64(String base64) {
        return this.unserializeFromBytes(DatatypeConverter.parseBase64Binary((String)base64));
    }

    public Serializable unserializeFromBytes(byte[] bytes) {
        try (Input input = new Input((InputStream)new ByteArrayInputStream(bytes));){
            Serializable obj;
            Serializable serializable = obj = (Serializable)this.kryo.readClassAndObject(input);
            return serializable;
        }
    }
}

