/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaSerializationHelper {
    private static final Logger logger = LoggerFactory.getLogger(JavaSerializationHelper.class);
    private List<String> trustedPackages = Arrays.asList("java.", "javax.", "org.pac4j.", "com.github.scribejava.", "org.opensaml.", "com.nimbusds.", "org.joda.");

    public String serializeToBase64(Serializable o) {
        return DatatypeConverter.printBase64Binary((byte[])this.serializeToBytes(o));
    }

    public byte[] serializeToBytes(Serializable o) {
        byte[] bytes = null;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(o);
            oos.flush();
            bytes = baos.toByteArray();
        }
        catch (IOException e) {
            logger.warn("cannot Java serialize object", (Throwable)e);
        }
        return bytes;
    }

    public Serializable unserializeFromBase64(String base64) {
        return this.unserializeFromBytes(DatatypeConverter.parseBase64Binary((String)base64));
    }

    public Serializable unserializeFromBytes(byte[] bytes) {
        Serializable o = null;
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
             RestrictedObjectInputStream ois = new RestrictedObjectInputStream(bais, this.trustedPackages);){
            o = (Serializable)ois.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            logger.warn("cannot Java deserialize object", (Throwable)e);
        }
        return o;
    }

    public List<String> getTrustedPackages() {
        return this.trustedPackages;
    }

    public void setTrustedPackages(List<String> trustedPackages) {
        this.trustedPackages = trustedPackages;
    }

    public String toString() {
        return CommonHelper.toString(this.getClass(), "trustedPackages", this.trustedPackages);
    }

    private static class RestrictedObjectInputStream
    extends ObjectInputStream {
        private final List<String> trustedPackages;

        private RestrictedObjectInputStream(InputStream in, List<String> trustedPackages) throws IOException {
            super(in);
            CommonHelper.assertNotNull("trustedPackages", trustedPackages);
            this.trustedPackages = trustedPackages;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String qualifiedClassName = desc.getName();
            for (String p : this.trustedPackages) {
                if (!qualifiedClassName.startsWith(p)) continue;
                return super.resolveClass(desc);
            }
            throw new ClassNotFoundException("Wont resolve untrusted class: " + qualifiedClassName);
        }

        @Override
        protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
            throw new ClassNotFoundException("Wont resolve proxy classes at all.");
        }
    }
}

