/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.profile;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pac4j.core.profile.AttributesDefinition;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UserProfile
implements Serializable,
Externalizable {
    private static final long serialVersionUID = 9020114478664816338L;
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private String id;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    public static final transient String SEPARATOR = "#";
    private boolean isRemembered = false;
    private Set<String> roles = new HashSet<String>();
    private Set<String> permissions = new HashSet<String>();
    private String clientName;

    public void build(Object id, Map<String, Object> attributes) {
        this.setId(id);
        this.addAttributes(attributes);
    }

    public AttributesDefinition getAttributesDefinition() {
        return null;
    }

    public void addAttribute(String key, Object value) {
        if (value != null) {
            AttributesDefinition definition = this.getAttributesDefinition();
            if (definition == null) {
                this.logger.debug("no conversion => key: {} / value: {} / {}", new Object[]{key, value, value.getClass()});
                this.attributes.put(key, value);
            } else if ((value = definition.convert(key, value)) != null) {
                ArrayList<Object> value2 = value instanceof Object[] ? new ArrayList<Object>(Arrays.asList((Object[])value)) : value;
                this.logger.debug("converted to => key: {} / value: {} / {}", new Object[]{key, value2, value2.getClass()});
                this.attributes.put(key, value2);
            }
        }
    }

    public void addAttributes(Map<String, Object> attributes) {
        if (attributes != null) {
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                this.addAttribute(entry.getKey(), entry.getValue());
            }
        }
    }

    public void removeAttribute(String key) {
        CommonHelper.assertNotNull("key", key);
        this.attributes.remove(key);
    }

    public void setId(Object id) {
        CommonHelper.assertNotNull("id", id);
        String sId = id.toString();
        String oldType = this.getClass().getSimpleName() + SEPARATOR;
        String type = this.getClass().getName() + SEPARATOR;
        if (sId.startsWith(type)) {
            sId = sId.substring(type.length());
        } else if (sId.startsWith(oldType)) {
            sId = sId.substring(oldType.length());
        }
        this.logger.debug("identifier: {}", (Object)sId);
        this.id = sId;
    }

    public String getId() {
        return this.id;
    }

    public String getTypedId() {
        return this.getClass().getName() + SEPARATOR + this.id;
    }

    @Deprecated
    public String getOldTypedId() {
        return this.getClass().getSimpleName() + SEPARATOR + this.id;
    }

    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public boolean containsAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public <T> T getAttribute(String name, Class<T> clazz) {
        Object attribute = this.getAttribute(name);
        if (attribute == null) {
            return null;
        }
        if (!clazz.isAssignableFrom(attribute.getClass())) {
            throw new ClassCastException("Attribute [" + name + " is of type " + attribute.getClass() + " when we were expecting " + clazz);
        }
        return (T)attribute;
    }

    public void addRole(String role) {
        CommonHelper.assertNotBlank("role", role);
        this.roles.add(role);
    }

    public void addRoles(List<String> roles) {
        CommonHelper.assertNotNull("roles", roles);
        this.roles.addAll(roles);
    }

    public void addRoles(Set<String> roles) {
        CommonHelper.assertNotNull("roles", roles);
        this.roles.addAll(roles);
    }

    public void addPermission(String permission) {
        CommonHelper.assertNotBlank("permission", permission);
        this.permissions.add(permission);
    }

    public void addPermissions(List<String> permissions) {
        CommonHelper.assertNotNull("permissions", permissions);
        this.permissions.addAll(permissions);
    }

    public void addPermissions(Set<String> permissions) {
        CommonHelper.assertNotNull("permissions", permissions);
        this.permissions.addAll(permissions);
    }

    public void setRemembered(boolean rme) {
        this.isRemembered = rme;
    }

    public Set<String> getRoles() {
        return Collections.unmodifiableSet(this.roles);
    }

    public Set<String> getPermissions() {
        return Collections.unmodifiableSet(this.permissions);
    }

    public boolean isRemembered() {
        return this.isRemembered;
    }

    public String toString() {
        return CommonHelper.toString(this.getClass(), "id", this.id, "attributes", this.attributes, "roles", this.roles, "permissions", this.permissions, "isRemembered", this.isRemembered);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.id);
        out.writeObject(this.attributes);
        out.writeBoolean(this.isRemembered);
        out.writeObject(this.roles);
        out.writeObject(this.permissions);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = (String)in.readObject();
        this.attributes = (Map)in.readObject();
        this.isRemembered = in.readBoolean();
        this.roles = (Set)in.readObject();
        this.permissions = (Set)in.readObject();
    }

    public void clearSensitiveData() {
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        CommonHelper.assertNotNull("clientName", clientName);
        this.clientName = clientName;
    }
}

