/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.config;

import org.pac4j.core.config.Config;
import org.pac4j.core.config.ConfigFactory;
import org.pac4j.core.exception.TechnicalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ConfigBuilder.class);

    public static synchronized Config build(String factoryName) {
        try {
            logger.info("Build the configuration from factory: {}", (Object)factoryName);
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = tccl == null ? Class.forName(factoryName) : Class.forName(factoryName, true, tccl);
            ConfigFactory factory = (ConfigFactory)clazz.newInstance();
            return factory.build();
        }
        catch (Exception e) {
            throw new TechnicalException("Cannot build configuration", e);
        }
    }
}

