/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.client;

import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.client.RedirectAction;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.creator.AuthenticatorProfileCreator;
import org.pac4j.core.profile.creator.ProfileCreator;
import org.pac4j.core.redirect.RedirectActionBuilder;
import org.pac4j.core.util.CommonHelper;

public abstract class IndirectClientV2<C extends Credentials, U extends CommonProfile>
extends IndirectClient<C, U> {
    private RedirectActionBuilder redirectActionBuilder;
    private CredentialsExtractor<C> credentialsExtractor;
    private Authenticator<C> authenticator;
    private ProfileCreator<C, U> profileCreator = AuthenticatorProfileCreator.INSTANCE;

    @Override
    protected RedirectAction retrieveRedirectAction(WebContext context) throws HttpAction {
        CommonHelper.assertNotNull("redirectActionBuilder", this.redirectActionBuilder);
        return this.redirectActionBuilder.redirect(context);
    }

    @Override
    protected C retrieveCredentials(WebContext context) throws HttpAction {
        CommonHelper.assertNotNull("credentialsExtractor", this.credentialsExtractor);
        CommonHelper.assertNotNull("authenticator", this.authenticator);
        try {
            C credentials = this.credentialsExtractor.extract(context);
            if (credentials == null) {
                return null;
            }
            this.authenticator.validate(credentials, context);
            return credentials;
        }
        catch (CredentialsException e) {
            this.logger.info("Failed to retrieve or validate credentials: {}", (Object)e.getMessage());
            this.logger.debug("Failed to retrieve or validate credentials", (Throwable)e);
            return null;
        }
    }

    @Override
    protected U retrieveUserProfile(C credentials, WebContext context) throws HttpAction {
        CommonHelper.assertNotNull("profileCreator", this.profileCreator);
        U profile = this.profileCreator.create(credentials, context);
        this.logger.debug("profile: {}", profile);
        return profile;
    }

    public RedirectActionBuilder getRedirectActionBuilder() {
        return this.redirectActionBuilder;
    }

    public void setRedirectActionBuilder(RedirectActionBuilder redirectActionBuilder) {
        if (this.redirectActionBuilder == null) {
            this.redirectActionBuilder = redirectActionBuilder;
        }
    }

    public CredentialsExtractor<C> getCredentialsExtractor() {
        return this.credentialsExtractor;
    }

    public void setCredentialsExtractor(CredentialsExtractor<C> credentialsExtractor) {
        if (this.credentialsExtractor == null) {
            this.credentialsExtractor = credentialsExtractor;
        }
    }

    public Authenticator<C> getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Authenticator<C> authenticator) {
        if (this.authenticator == null) {
            this.authenticator = authenticator;
        }
    }

    public ProfileCreator<C, U> getProfileCreator() {
        return this.profileCreator;
    }

    public void setProfileCreator(ProfileCreator<C, U> profileCreator) {
        if (this.profileCreator == null || this.profileCreator == AuthenticatorProfileCreator.INSTANCE) {
            this.profileCreator = profileCreator;
        }
    }

    @Override
    public String toString() {
        return CommonHelper.toString(this.getClass(), "name", this.getName(), "callbackUrl", this.callbackUrl, "callbackUrlResolver", this.callbackUrlResolver, "ajaxRequestResolver", this.getAjaxRequestResolver(), "redirectActionBuilder", this.redirectActionBuilder, "credentialsExtractor", this.credentialsExtractor, "authenticator", this.authenticator, "profileCreator", this.profileCreator);
    }
}

