/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.client;

import org.pac4j.core.client.BaseClient;
import org.pac4j.core.client.RedirectAction;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.http.AjaxRequestResolver;
import org.pac4j.core.http.CallbackUrlResolver;
import org.pac4j.core.http.DefaultAjaxRequestResolver;
import org.pac4j.core.http.DefaultCallbackUrlResolver;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.util.CommonHelper;

public abstract class IndirectClient<C extends Credentials, U extends CommonProfile>
extends BaseClient<C, U> {
    public static final String ATTEMPTED_AUTHENTICATION_SUFFIX = "$attemptedAuthentication";
    protected String callbackUrl;
    private boolean includeClientNameInCallbackUrl = true;
    private AjaxRequestResolver ajaxRequestResolver = new DefaultAjaxRequestResolver();
    protected CallbackUrlResolver callbackUrlResolver = new DefaultCallbackUrlResolver();

    @Override
    protected void internalInit(WebContext context) {
        CommonHelper.assertNotBlank("callbackUrl", this.callbackUrl);
        CommonHelper.assertNotNull("callbackUrlResolver", this.callbackUrlResolver);
        CommonHelper.assertNotNull("ajaxRequestResolver", this.ajaxRequestResolver);
    }

    @Override
    public final HttpAction redirect(WebContext context) throws HttpAction {
        RedirectAction action = this.getRedirectAction(context);
        if (action.getType() == RedirectAction.RedirectType.REDIRECT) {
            return HttpAction.redirect("redirection via 302", context, action.getLocation());
        }
        return HttpAction.ok("redirection via 200", context, action.getContent());
    }

    public final RedirectAction getRedirectAction(WebContext context) throws HttpAction {
        this.init(context);
        if (this.ajaxRequestResolver.isAjax(context)) {
            this.logger.info("AJAX request detected -> returning 401");
            this.cleanRequestedUrl(context);
            throw HttpAction.unauthorized("AJAX request -> 401", context, null);
        }
        String attemptedAuth = (String)context.getSessionAttribute(this.getName() + ATTEMPTED_AUTHENTICATION_SUFFIX);
        if (CommonHelper.isNotBlank(attemptedAuth)) {
            this.cleanAttemptedAuthentication(context);
            this.cleanRequestedUrl(context);
            throw HttpAction.unauthorized("authentication already tried -> forbidden", context, null);
        }
        return this.retrieveRedirectAction(context);
    }

    protected abstract RedirectAction retrieveRedirectAction(WebContext var1) throws HttpAction;

    @Override
    public final C getCredentials(WebContext context) throws HttpAction {
        this.init(context);
        Object credentials = this.retrieveCredentials(context);
        if (credentials == null) {
            context.setSessionAttribute(this.getName() + ATTEMPTED_AUTHENTICATION_SUFFIX, "true");
        } else {
            this.cleanAttemptedAuthentication(context);
        }
        return credentials;
    }

    private void cleanRequestedUrl(WebContext context) {
        context.setSessionAttribute("pac4jRequestedUrl", "");
    }

    private void cleanAttemptedAuthentication(WebContext context) {
        context.setSessionAttribute(this.getName() + ATTEMPTED_AUTHENTICATION_SUFFIX, "");
    }

    public String computeFinalCallbackUrl(WebContext context) {
        return this.callbackUrlResolver.compute(this.callbackUrl, context);
    }

    protected String getStateParameter(WebContext webContext) {
        throw new UnsupportedOperationException("To be implemented in subclasses if required");
    }

    public boolean isIncludeClientNameInCallbackUrl() {
        return this.includeClientNameInCallbackUrl;
    }

    public void setIncludeClientNameInCallbackUrl(boolean includeClientNameInCallbackUrl) {
        this.includeClientNameInCallbackUrl = includeClientNameInCallbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public AjaxRequestResolver getAjaxRequestResolver() {
        return this.ajaxRequestResolver;
    }

    public void setAjaxRequestResolver(AjaxRequestResolver ajaxRequestResolver) {
        this.ajaxRequestResolver = ajaxRequestResolver;
    }

    public CallbackUrlResolver getCallbackUrlResolver() {
        return this.callbackUrlResolver;
    }

    public void setCallbackUrlResolver(CallbackUrlResolver callbackUrlResolver) {
        this.callbackUrlResolver = callbackUrlResolver;
    }

    @Override
    public String toString() {
        return CommonHelper.toString(this.getClass(), "name", this.getName(), "callbackUrl", this.callbackUrl, "callbackUrlResolver", this.callbackUrlResolver, "ajaxRequestResolver", this.ajaxRequestResolver);
    }
}

