/**
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

// DO NOT EDIT THIS GENERATED OUTPUT DIRECTLY!
// This file should be overwritten as part of your build process.
// If you need to extend the behavior of the generated service worker, the best approach is to write
// additional code and include it using the importScripts option:
//   https://github.com/GoogleChrome/sw-precache#importscripts-arraystring
//
// Alternatively, it's possible to make changes to the underlying template file and then use that as the
// new base for generating output, via the templateFilePath option:
//   https://github.com/GoogleChrome/sw-precache#templatefilepath-string
//
// If you go that route, make sure that whenever you update your sw-precache dependency, you reconcile any
// changes made to this original template file with your modified copy.

// This generated service worker JavaScript will precache your site's resources.
// The code needs to be saved in a .js file at the top-level of your site, and registered
// from your pages in order to be used. See
// https://github.com/googlechrome/sw-precache/blob/master/demo/app/js/service-worker-registration.js
// for an example of how you can register this script and handle various service worker events.

/* eslint-env worker, serviceworker */
/* eslint-disable indent, no-unused-vars, no-multiple-empty-lines, max-nested-callbacks, space-before-function-paren, quotes, comma-spacing */
'use strict';

var precacheConfig = [["allclasses-frame.html","dfc581f98b8e5b7edd3f5cbf482f4ddc"],["allclasses-noframe.html","6747f4425e35256daf6c997632e3f1f6"],["constant-values.html","bf10d263398721288636ae2e15ee5a90"],["deprecated-list.html","9606ba9737b7911618350b63bb0aa35b"],["favicon.ico","05e61206186c2eee9054011bcf15b864"],["help-doc.html","e49c5ddb832b83669846903c97f32b8d"],["index-files/index-1.html","fe5bd069dfb0decf2ae4bf7e7c3fea79"],["index-files/index-10.html","4840f6e4c1acb4e809b0c033a9be9859"],["index-files/index-11.html","a11b553b9ba352503dfe31f7f580fb42"],["index-files/index-12.html","06ef576a992d08001a84a9fd00b3ad35"],["index-files/index-13.html","2db126a7fa1bc2daeaddc03acee9e8ba"],["index-files/index-14.html","112d307cf1626c6ec2eea3385bf12bdc"],["index-files/index-15.html","d7c32b34141a5f43a671b1fd07228ea9"],["index-files/index-16.html","9be27ed0fd1b9c20b8d5eb0c51429d5d"],["index-files/index-17.html","89822a46d124371826f73ea75ebb2bc1"],["index-files/index-18.html","2ad49efb144c6f3e13c3d8ff2c4b5840"],["index-files/index-19.html","ead027c940b3eb42426c723210eef4b8"],["index-files/index-2.html","6ba091280a8fabf0165da98292f2af6f"],["index-files/index-20.html","c3745327f6701d407ce547cb762e2df6"],["index-files/index-3.html","5afa645a38586be7c24e40060ea658ee"],["index-files/index-4.html","57f4dac819a7f04529631979b04a229f"],["index-files/index-5.html","7baae4ad3697f47f4830f0e1f2b5f5ec"],["index-files/index-6.html","4ad4546ff209f522dec836ab168071f6"],["index-files/index-7.html","2c52ff5f52c2c2498c9fe52725652413"],["index-files/index-8.html","ddba805ad59125f82b00fcfa751ed58f"],["index-files/index-9.html","8d497a26bcbf77cc01c71a67ccc36351"],["index.html","c111fdf8265955a9256feb97084a64f8"],["js/highlight-8.6-java/highlight.pack.js","deec56e4bb489b0ce943987284aac274"],["js/highlight-8.6-java/styles/obsidian.css","d60cd29c66c835762c95d2ce6da21142"],["js/index.js","dfc78156c8712ef6c546ea1037a604ef"],["js/jdk6-project-version-insert.js","ddee726b95840e7606e132d95c65ef27"],["js/jdk6-project-version-insert.min.js","a6a8d425f512ba0a8e2340504f134553"],["js/jquery-1.7.min.js","25721ced154b3a99e818431446d7506d"],["org/mockito/AdditionalAnswers.html","caaabb5e4600d298c1169e1cee055eb2"],["org/mockito/AdditionalMatchers.html","cd2a4f19c77fb715c45d7d236d181787"],["org/mockito/Answers.html","24d1c87072137d9d3a61f365138969a8"],["org/mockito/ArgumentCaptor.html","fa83c44ab0be156011a03667c7ce92e5"],["org/mockito/ArgumentMatcher.html","de9b14fd2681fa4873bf19ddd027cf6d"],["org/mockito/ArgumentMatchers.html","7bc47e0d257e0a6d4692a83f4c1ca274"],["org/mockito/BDDMockito.BDDMyOngoingStubbing.html","419d7b6ae0b8503e1a75f195812957e7"],["org/mockito/BDDMockito.BDDStubber.html","5c46dc77359f08253f0ebd1f700e040d"],["org/mockito/BDDMockito.Then.html","194e46f20898a060e1772d1dd30dd641"],["org/mockito/BDDMockito.html","158fd68e732ac6be3bb78c2e9f33ac2e"],["org/mockito/Captor.html","4a55e14905789d20a486f614064d3f17"],["org/mockito/InOrder.html","f9a69be5af9353ee711eda316b315407"],["org/mockito/Incubating.html","a798c90fa0b269c51da67123b8be4856"],["org/mockito/InjectMocks.html","45399c6682c15704daed2d5cf7cc3a36"],["org/mockito/Matchers.html","a1122ece70941cf3e9395e8f2a85301d"],["org/mockito/Mock.html","5d80c192ec2454d11e6ad0abbe99d045"],["org/mockito/MockSettings.html","6867149c97d842a9657bcef114bbaed6"],["org/mockito/MockingDetails.html","0ec32e1f0e919d3fddeab444f3018291"],["org/mockito/Mockito.html","2c3d0c05e08596a6e9214a0c36c4c14c"],["org/mockito/MockitoAnnotations.html","c4144558db0b99b99f52a5c5b4bc2ab4"],["org/mockito/MockitoDebugger.html","c3abc98425739f319e4460b61e0d58af"],["org/mockito/MockitoFramework.html","01412dbe4827cc5a28ca765dd91d6093"],["org/mockito/MockitoSession.html","fb40241ce0b786260e08af4b7d852d6f"],["org/mockito/Spy.html","a67a306ef0cdeca9679587935da15217"],["org/mockito/class-use/AdditionalAnswers.html","401eaef63264dbee9fe6a5eed8acaa2b"],["org/mockito/class-use/AdditionalMatchers.html","86a8e9c60b8eb2d5b13718339984b1ef"],["org/mockito/class-use/Answers.html","651d6c0dd2474cc686393091bb267598"],["org/mockito/class-use/ArgumentCaptor.html","5d4eca3caa5c0327c6d5b6291bd1698d"],["org/mockito/class-use/ArgumentMatcher.html","1644301ea22725d835bdd1ddbe81f1b5"],["org/mockito/class-use/ArgumentMatchers.html","e9424fc4c5041dd9c2c967aab88e06e4"],["org/mockito/class-use/BDDMockito.BDDMyOngoingStubbing.html","a547a8d1d59f88a86f6d4136fdb83755"],["org/mockito/class-use/BDDMockito.BDDStubber.html","6a7df921801a3cd3035a97b36804551c"],["org/mockito/class-use/BDDMockito.Then.html","0d5430df9ba946aa2d274e7d1d05dde2"],["org/mockito/class-use/BDDMockito.html","971741aed2a4a8b303ba4e4020b2c55d"],["org/mockito/class-use/Captor.html","b8c0307fd778c6644cfcad93b23d55f0"],["org/mockito/class-use/InOrder.html","a8ff1ada18590d6002ef5bb4395b7fd6"],["org/mockito/class-use/Incubating.html","12edb9681619abf3aa10b3f63472ab88"],["org/mockito/class-use/InjectMocks.html","95299613c9073b95c6960c322158e9b4"],["org/mockito/class-use/Matchers.html","b580a59119dc4fcd6c25efe7c678419b"],["org/mockito/class-use/Mock.html","24caf784b9422a9b17508537a73c9b71"],["org/mockito/class-use/MockSettings.html","4cede04795ffbb448be312063f681a64"],["org/mockito/class-use/MockingDetails.html","24c3cc275750e5d51ae6823d26ebbf61"],["org/mockito/class-use/Mockito.html","f2c1b942e6d15b820a9954a2283431ef"],["org/mockito/class-use/MockitoAnnotations.html","4b47c04fc61e6aac3549bea21a686983"],["org/mockito/class-use/MockitoDebugger.html","eb637e8de99b76fd9b5b8eecabe3d083"],["org/mockito/class-use/MockitoFramework.html","12d63a39c285bc0029743f26567ae5ac"],["org/mockito/class-use/MockitoSession.html","7a3e4850f4e687dcfc1d54660e14be2b"],["org/mockito/class-use/Spy.html","c9fc7360efd6c1147ef7c1f557436bfc"],["org/mockito/configuration/AnnotationEngine.html","8b944183205ebbea16724544c8b54021"],["org/mockito/configuration/DefaultMockitoConfiguration.html","f60e4414c02ea08a55e6fb0dd1f47dca"],["org/mockito/configuration/IMockitoConfiguration.html","b3b61b715e621b01ccad3c650fc07739"],["org/mockito/configuration/class-use/AnnotationEngine.html","b6dae6705f68f5268fada1e6a523f87f"],["org/mockito/configuration/class-use/DefaultMockitoConfiguration.html","69b12c2ba8c8137b2d608d101476d000"],["org/mockito/configuration/class-use/IMockitoConfiguration.html","f648b75b4463c2d147d228c7be34a15d"],["org/mockito/configuration/package-frame.html","966e5132224c99a79c2bd90ce9c14dbf"],["org/mockito/configuration/package-summary.html","c18f81d1f037cf6652d250a940a95b2c"],["org/mockito/configuration/package-tree.html","607e12abb1385cdc7872049f4a36850a"],["org/mockito/configuration/package-use.html","eb763d8462d0b5fc3d12e38b955f4b04"],["org/mockito/exceptions/base/MockitoAssertionError.html","027f3fd308d6eca7ee2e221feafa1657"],["org/mockito/exceptions/base/MockitoException.html","3f84b5b3b0952a60d269415d72b4c962"],["org/mockito/exceptions/base/MockitoInitializationException.html","07e80881db9e4f31397549c0db763af8"],["org/mockito/exceptions/base/MockitoSerializationIssue.html","b49ad8f76db48308e6d9e04bf3a6cdb4"],["org/mockito/exceptions/base/class-use/MockitoAssertionError.html","e1684589e59e05f73fb67abbe2e8b2ea"],["org/mockito/exceptions/base/class-use/MockitoException.html","071c7279ade625c4598072994c166a9f"],["org/mockito/exceptions/base/class-use/MockitoInitializationException.html","c4134ab1203c834de7632e782142dd53"],["org/mockito/exceptions/base/class-use/MockitoSerializationIssue.html","8cf83d3139ffac36a216ac12f144eab0"],["org/mockito/exceptions/base/package-frame.html","10a6abe16c8a673f0f25134f7310050f"],["org/mockito/exceptions/base/package-summary.html","b6b20f4004967cf01446f4bd6838cab1"],["org/mockito/exceptions/base/package-tree.html","2bf6faafb03392e43e2bd287bb13456b"],["org/mockito/exceptions/base/package-use.html","9c5a568d6c5eec3ff2a147aa745a1d49"],["org/mockito/exceptions/misusing/CannotStubVoidMethodWithReturnValue.html","4bc10ec640cb0314b7568878c04bc597"],["org/mockito/exceptions/misusing/CannotVerifyStubOnlyMock.html","73125e526e1165aad675b625a8cd6880"],["org/mockito/exceptions/misusing/FriendlyReminderException.html","1dd117c0bd4cc94437d562dda1d87d3b"],["org/mockito/exceptions/misusing/InvalidUseOfMatchersException.html","cf1869d79abc30ae369a6b91c960484c"],["org/mockito/exceptions/misusing/MissingMethodInvocationException.html","4b4df48ba459a98a86308944e1a34373"],["org/mockito/exceptions/misusing/MockitoConfigurationException.html","a00b8b391f31d27127a98ed3e9305c1d"],["org/mockito/exceptions/misusing/NotAMockException.html","987b08444bb4b37fb3124b1b7df11e5d"],["org/mockito/exceptions/misusing/NullInsteadOfMockException.html","d84b8ec15fc527e21f2a0b5e385dac40"],["org/mockito/exceptions/misusing/PotentialStubbingProblem.html","98c4bbbf47289d51c27885d100e05222"],["org/mockito/exceptions/misusing/RedundantListenerException.html","2bd64e97cecf4839449eaac4e5f69a96"],["org/mockito/exceptions/misusing/UnfinishedMockingSessionException.html","0965031dffa86bd5273701e10eef3952"],["org/mockito/exceptions/misusing/UnfinishedStubbingException.html","796684c18156d257ca758b2f3831d153"],["org/mockito/exceptions/misusing/UnfinishedVerificationException.html","02d7cfc06511d1ad519de01a909986d1"],["org/mockito/exceptions/misusing/UnnecessaryStubbingException.html","177100ad7ce8534ee7d8e5042e4082d5"],["org/mockito/exceptions/misusing/WrongTypeOfReturnValue.html","16234f0ef50d1517492c91fd8546b2a6"],["org/mockito/exceptions/misusing/class-use/CannotStubVoidMethodWithReturnValue.html","928fb873ddad6b7451a83fe1ff76a128"],["org/mockito/exceptions/misusing/class-use/CannotVerifyStubOnlyMock.html","1f38d4d964f8177b5e3254b685d3b7dd"],["org/mockito/exceptions/misusing/class-use/FriendlyReminderException.html","a90fd0a7c84bf6b1002799381d7f8888"],["org/mockito/exceptions/misusing/class-use/InvalidUseOfMatchersException.html","4f551ba0b9e58278620c262bf7613569"],["org/mockito/exceptions/misusing/class-use/MissingMethodInvocationException.html","b964a37b9514414b9711b656152e1880"],["org/mockito/exceptions/misusing/class-use/MockitoConfigurationException.html","1510a807590e665f71a3b023e1912c23"],["org/mockito/exceptions/misusing/class-use/NotAMockException.html","40e7ba67aa574e30646eff9c6d3ab04a"],["org/mockito/exceptions/misusing/class-use/NullInsteadOfMockException.html","3d2c36317639cf3b6417261cd317ddc4"],["org/mockito/exceptions/misusing/class-use/PotentialStubbingProblem.html","29d494c7384c1fc04a5240323196c724"],["org/mockito/exceptions/misusing/class-use/RedundantListenerException.html","19b58e5b239568165d100afa10830563"],["org/mockito/exceptions/misusing/class-use/UnfinishedMockingSessionException.html","0d8ef7440e34c48c01c280aeca038e73"],["org/mockito/exceptions/misusing/class-use/UnfinishedStubbingException.html","a5e7c836a37054b46ba435d594af297d"],["org/mockito/exceptions/misusing/class-use/UnfinishedVerificationException.html","6fa995f764a8930a781b6114e89f50b6"],["org/mockito/exceptions/misusing/class-use/UnnecessaryStubbingException.html","c9d566f0cedc28da56e1959aefb0a29f"],["org/mockito/exceptions/misusing/class-use/WrongTypeOfReturnValue.html","c9812a4992b58450df41835c93e238eb"],["org/mockito/exceptions/misusing/package-frame.html","e5341924982044ffa74715030dd32248"],["org/mockito/exceptions/misusing/package-summary.html","bf4e415ba92f86acb7cf74193d34233b"],["org/mockito/exceptions/misusing/package-tree.html","fc82545935e62b42db870d7921ef0aa0"],["org/mockito/exceptions/misusing/package-use.html","5095ce915ec5b144903fa6185795a041"],["org/mockito/exceptions/stacktrace/StackTraceCleaner.html","e3033b23647131cbf1f878b26743fa5d"],["org/mockito/exceptions/stacktrace/class-use/StackTraceCleaner.html","9f8550734500139823604116bd4d0c3a"],["org/mockito/exceptions/stacktrace/package-frame.html","8ee6156fae2dccbc9d0454a948270f30"],["org/mockito/exceptions/stacktrace/package-summary.html","32f0c417a425dab6b966470461c9a0f8"],["org/mockito/exceptions/stacktrace/package-tree.html","1f519ff727b00c0be76e8e38080a0551"],["org/mockito/exceptions/stacktrace/package-use.html","6e3b17e5bd833c73434365c43a43f272"],["org/mockito/exceptions/verification/ArgumentsAreDifferent.html","90241c75f1fc45d32b3b5cf8a150f300"],["org/mockito/exceptions/verification/NeverWantedButInvoked.html","1418e53789541d7ca7dce71fef56b64e"],["org/mockito/exceptions/verification/NoInteractionsWanted.html","ff746f6d284242108e94e4e80b5296f8"],["org/mockito/exceptions/verification/SmartNullPointerException.html","4fb7335d15c80cfb246e90aad0aefbd7"],["org/mockito/exceptions/verification/TooLittleActualInvocations.html","314a0ce39cfdecd7ec379be511181826"],["org/mockito/exceptions/verification/TooManyActualInvocations.html","d82d86cbea60c23fecf4ce2d9096a79f"],["org/mockito/exceptions/verification/VerificationInOrderFailure.html","49314f8471f1a3542bf25f5944987433"],["org/mockito/exceptions/verification/WantedButNotInvoked.html","028278fe9c1c3a88fbae0a18d3f4609d"],["org/mockito/exceptions/verification/class-use/ArgumentsAreDifferent.html","59ea7cf90c41f6647fa818d0c14a2a70"],["org/mockito/exceptions/verification/class-use/NeverWantedButInvoked.html","50087cc6239adf41fa41c56d2ff6cb5f"],["org/mockito/exceptions/verification/class-use/NoInteractionsWanted.html","254e9370b8f4754d5b55d42300c426f6"],["org/mockito/exceptions/verification/class-use/SmartNullPointerException.html","e9db5a925c50ef8b2af19f3bafd1c551"],["org/mockito/exceptions/verification/class-use/TooLittleActualInvocations.html","c516616c88ca039ca6de231395e1d39c"],["org/mockito/exceptions/verification/class-use/TooManyActualInvocations.html","6ec48cdd0d5f45ff6c43be63f854e349"],["org/mockito/exceptions/verification/class-use/VerificationInOrderFailure.html","9dd343df3a0a97412d3646a9317385fc"],["org/mockito/exceptions/verification/class-use/WantedButNotInvoked.html","e4f1a2492e092428e86a1d95d0af0643"],["org/mockito/exceptions/verification/junit/ArgumentsAreDifferent.html","1f3412946f0afb95dbf9855479bed6a4"],["org/mockito/exceptions/verification/junit/class-use/ArgumentsAreDifferent.html","218ce72f10fac5b025bde1536710e320"],["org/mockito/exceptions/verification/junit/package-frame.html","d9fd4a6391a965a85bae71e6f9ade073"],["org/mockito/exceptions/verification/junit/package-summary.html","77317345e724a224b3194644fbd5260d"],["org/mockito/exceptions/verification/junit/package-tree.html","c6d36653653d8dbdc194316ea5247d7d"],["org/mockito/exceptions/verification/junit/package-use.html","aa17c28d7160b38fff4f8a213136bc1b"],["org/mockito/exceptions/verification/package-frame.html","792fc2298e9060106a15252efcecd8eb"],["org/mockito/exceptions/verification/package-summary.html","21b503a99e7ed655d35159e51c2e108b"],["org/mockito/exceptions/verification/package-tree.html","a27ae4ed2529f546fdae626574089782"],["org/mockito/exceptions/verification/package-use.html","028d6abcacf1e3a18bed7b61c0ff9cd8"],["org/mockito/hamcrest/MockitoHamcrest.html","4753c0be42b64736b3ea4b9c9dd1d0c0"],["org/mockito/hamcrest/class-use/MockitoHamcrest.html","3ec86d150190088862d7e9633a530cb0"],["org/mockito/hamcrest/package-frame.html","6ce7e3ff064e82d9c930007614521773"],["org/mockito/hamcrest/package-summary.html","4e4053275b11fd089d1e9fc6c1bc4036"],["org/mockito/hamcrest/package-tree.html","466ea51a9a661e0da89e1ce6f47880b1"],["org/mockito/hamcrest/package-use.html","42e3f7900e06efb2c350e80d1eb243e4"],["org/mockito/invocation/DescribedInvocation.html","a672104f257af163017ca8950aa39a96"],["org/mockito/invocation/Invocation.html","3711c647c7d1a70c9836eec0d883fed1"],["org/mockito/invocation/InvocationOnMock.html","b58f63404e0b45d7750a08699b38469e"],["org/mockito/invocation/Location.html","303a920383561c6cf403a6775f5b69a8"],["org/mockito/invocation/MatchableInvocation.html","de4ee5f0b414e0f5cf50eab5158c8b9b"],["org/mockito/invocation/MockHandler.html","684453bded436406b3bcd7ce2d39c9ce"],["org/mockito/invocation/StubInfo.html","395b8e29ebab18da3b68ebc4088b92e4"],["org/mockito/invocation/class-use/DescribedInvocation.html","40a7f81c60b2fb1359ba2733dcf776ea"],["org/mockito/invocation/class-use/Invocation.html","3388e429538be7037d6994f254676250"],["org/mockito/invocation/class-use/InvocationOnMock.html","cd246b53cd33bcbc48318d9ab1def08e"],["org/mockito/invocation/class-use/Location.html","e4b2088faf287750a5e2e6e0873bab6f"],["org/mockito/invocation/class-use/MatchableInvocation.html","4efaf93799ecae9e43e6c185ac199fc9"],["org/mockito/invocation/class-use/MockHandler.html","59704421460495357f047d33d8f8da0d"],["org/mockito/invocation/class-use/StubInfo.html","d391b02ad7aa0d2d9630fd6ca76a2636"],["org/mockito/invocation/package-frame.html","7c1f627a630a8e7fc5e9e4a4392ce9ac"],["org/mockito/invocation/package-summary.html","2875dbc85f7883878b4ed9b2de8b4e99"],["org/mockito/invocation/package-tree.html","2d000379490d49702e4c6da6de325345"],["org/mockito/invocation/package-use.html","9a2d14efbea344e1c98f8dfcddbdfc69"],["org/mockito/junit/MockitoJUnit.html","47ecc63f07119942ac4c5c550beca563"],["org/mockito/junit/MockitoJUnitRunner.Silent.html","bec8d4f58ed3d4503e730cb04f1f369a"],["org/mockito/junit/MockitoJUnitRunner.Strict.html","bdf3e485c76ee69450447f835e4f22db"],["org/mockito/junit/MockitoJUnitRunner.StrictStubs.html","69e052a38e45a17d4d58c94184361704"],["org/mockito/junit/MockitoJUnitRunner.html","53797cf199f77b23714b2a237b4e9d57"],["org/mockito/junit/MockitoRule.html","6b3580e2922cd79ac5330d076903bba2"],["org/mockito/junit/VerificationCollector.html","1a5169be5dbb1f1a37155aa8d2f4bede"],["org/mockito/junit/class-use/MockitoJUnit.html","3856277d3b1e32a557e0d788e4e1f6b9"],["org/mockito/junit/class-use/MockitoJUnitRunner.Silent.html","22e3e1ee0088d1f74027387a53569238"],["org/mockito/junit/class-use/MockitoJUnitRunner.Strict.html","ac3e03f0f24b853fc3c619527efa3894"],["org/mockito/junit/class-use/MockitoJUnitRunner.StrictStubs.html","ecbe5b17c9a75fe0718035905683dfcf"],["org/mockito/junit/class-use/MockitoJUnitRunner.html","0ceab04597bc224b31866c099a8bacd9"],["org/mockito/junit/class-use/MockitoRule.html","43abe605dbe7828d458d5ee7ce175d7d"],["org/mockito/junit/class-use/VerificationCollector.html","740d64fd9830b99309e5eec589ebd48b"],["org/mockito/junit/package-frame.html","b3a1431676144ecb16d6bdfafdc252b8"],["org/mockito/junit/package-summary.html","81e17fe92b8689efadfecfcea6903062"],["org/mockito/junit/package-tree.html","066a7e950f7b77d5c12c4b34903e98e3"],["org/mockito/junit/package-use.html","664abe866c8688e826a2fdf4064f7743"],["org/mockito/listeners/InvocationListener.html","1322b6c52c0031df7ba5ce2c9cb6c22d"],["org/mockito/listeners/MethodInvocationReport.html","d97d793a9824f6dca7200761714e2592"],["org/mockito/listeners/MockCreationListener.html","08f890fad533f4a12af2206a51301e74"],["org/mockito/listeners/MockitoListener.html","0e500387bd64a2da169554403cc1a08c"],["org/mockito/listeners/VerificationListener.html","036c426bcc083dcf0a277df517da6ce5"],["org/mockito/listeners/class-use/InvocationListener.html","541290f89df913ed66fcef8c3075b92b"],["org/mockito/listeners/class-use/MethodInvocationReport.html","0ac9322d0226f650a51c30a3068304d7"],["org/mockito/listeners/class-use/MockCreationListener.html","41bfefb325de24140484940bb4511fe4"],["org/mockito/listeners/class-use/MockitoListener.html","2ed9c42f2ceef711109c6f64e168658b"],["org/mockito/listeners/class-use/VerificationListener.html","7520653713a3ba525344f91d91b7ad13"],["org/mockito/listeners/package-frame.html","65639a8bdd1e9184075de3cfdac63a88"],["org/mockito/listeners/package-summary.html","1e19de4a1b1ef16b521178adddaa3390"],["org/mockito/listeners/package-tree.html","1038ea9a779e4255e7ab0e5d7853bd90"],["org/mockito/listeners/package-use.html","d79945c200c69744e845125d3273fc8f"],["org/mockito/mock/MockCreationSettings.html","d967bb3fd64c2fb9ada1e37451f6b849"],["org/mockito/mock/MockName.html","2d70a66e387118c9bdd355e82b0fb8d2"],["org/mockito/mock/SerializableMode.html","00bbd1c4bb5240dbb91c51ed7ce7792d"],["org/mockito/mock/class-use/MockCreationSettings.html","66892b203ef3687f5b9940be400b5094"],["org/mockito/mock/class-use/MockName.html","7c09a51cce0ebf66d08dd0212bc7fff8"],["org/mockito/mock/class-use/SerializableMode.html","ec4019a9df1d0bd920c4a177583a81ce"],["org/mockito/mock/package-frame.html","e3aca8f1a28ffb10f3c5600425bd6c48"],["org/mockito/mock/package-summary.html","5cbd15122b473e0e33eb3ea5cba7dc1a"],["org/mockito/mock/package-tree.html","5313439a6843fa1ba2db5636d27a7f82"],["org/mockito/mock/package-use.html","0318ffc06c2a0216750bcaf0a16a78f9"],["org/mockito/package-frame.html","4d875ff70335262ee2d4cffed72cb7a8"],["org/mockito/package-summary.html","542eea60488dceede4fe4c20f1f0413b"],["org/mockito/package-tree.html","9e60b3df1a876d5e56d1416c6069ea65"],["org/mockito/package-use.html","cf7f85d62dfd72bd404d5ef121060f36"],["org/mockito/plugins/AnnotationEngine.html","b184b6bee0dd2974a44f03b2921ec950"],["org/mockito/plugins/InstantiatorProvider.html","16e74704074736718bec1ec8d981389d"],["org/mockito/plugins/MockMaker.TypeMockability.html","7b5c5061bb17d778031f95c8b148deaf"],["org/mockito/plugins/MockMaker.html","fde09b34b6941c07192ce56f1f8d6f63"],["org/mockito/plugins/PluginSwitch.html","85e2ad4dc2f5b627dbf83dce8e29a86d"],["org/mockito/plugins/StackTraceCleanerProvider.html","ab260e6762b50dcd6cdb35906e360d2d"],["org/mockito/plugins/class-use/AnnotationEngine.html","e241b86d5c593bce1ec517cf8f22a625"],["org/mockito/plugins/class-use/InstantiatorProvider.html","a5bde2865dbaa24f8a1b4fbb58d9b34b"],["org/mockito/plugins/class-use/MockMaker.TypeMockability.html","58e53633a061b84a882e27cdc3d55bb6"],["org/mockito/plugins/class-use/MockMaker.html","20b091036d0bcf03d8fcce604d2f753e"],["org/mockito/plugins/class-use/PluginSwitch.html","21c31361282198790184327207d055ff"],["org/mockito/plugins/class-use/StackTraceCleanerProvider.html","a9346067414138f7706a54a0c051f873"],["org/mockito/plugins/package-frame.html","623fe8fa0392a268dc94fea94cae28b7"],["org/mockito/plugins/package-summary.html","da4b18d04e4052f589ff95c75b241226"],["org/mockito/plugins/package-tree.html","fbe6b5ef5182b719249b498380aad387"],["org/mockito/plugins/package-use.html","15538357f314b3c9d1f61201330b80bc"],["org/mockito/quality/MockitoHint.html","d6e52d8d11ccdbd21b47a2aef6083a5c"],["org/mockito/quality/Strictness.html","eb35ea2e6d200090acc78425f9f403dc"],["org/mockito/quality/class-use/MockitoHint.html","997674338e64840fae4c991d8632443c"],["org/mockito/quality/class-use/Strictness.html","18d7478afa5520f1f98575a934aae15c"],["org/mockito/quality/package-frame.html","caa9465df0827a9296cdadd7c84cbd7f"],["org/mockito/quality/package-summary.html","a706b9d18f2a35d94a11b721ab8fb511"],["org/mockito/quality/package-tree.html","2020b12740c926f335c676bb7db4f4cf"],["org/mockito/quality/package-use.html","9077288b18d0099e206412e08941e43c"],["org/mockito/runners/ConsoleSpammingMockitoJUnitRunner.html","73dfd2d10712f4974f2e69236a6a745b"],["org/mockito/runners/MockitoJUnitRunner.Silent.html","e895365aabd43f53c547d0da8235018b"],["org/mockito/runners/MockitoJUnitRunner.Strict.html","7fce538aba9fc0bfa609dff0d771380a"],["org/mockito/runners/MockitoJUnitRunner.html","ea9438931403d41b63a3aa4e8eef10b1"],["org/mockito/runners/VerboseMockitoJUnitRunner.html","cb56b1cef349d9f92998b7156d606b4a"],["org/mockito/runners/class-use/ConsoleSpammingMockitoJUnitRunner.html","a6f2b3a01f692998fbed961426484718"],["org/mockito/runners/class-use/MockitoJUnitRunner.Silent.html","b668f9009d14e5e79929151e988a3bd3"],["org/mockito/runners/class-use/MockitoJUnitRunner.Strict.html","6e0a938850927ce2557040ca7e9a0491"],["org/mockito/runners/class-use/MockitoJUnitRunner.html","8dc9ccbbfa82448123f5b92f8d97599c"],["org/mockito/runners/class-use/VerboseMockitoJUnitRunner.html","b8b303f3401b04c313d89f3b2061ddc6"],["org/mockito/runners/package-frame.html","8f4eb29aac328ad5cb4386c0e1b6b0f9"],["org/mockito/runners/package-summary.html","7ee5da4157292d4c73265b9cdc241997"],["org/mockito/runners/package-tree.html","846f13040bba4b43dbf2f5fe58b88cd4"],["org/mockito/runners/package-use.html","77866e07c32bb96d5c3178bd1a40d918"],["org/mockito/session/MockitoSessionBuilder.html","7e80a3a7fe786dc2b7d8d48daf5016e8"],["org/mockito/session/class-use/MockitoSessionBuilder.html","5aa2af9e78d9504703500f18a1298c3f"],["org/mockito/session/package-frame.html","631473b371b79ac3be073010b7131164"],["org/mockito/session/package-summary.html","8d1b53dc26a65c4227ab6eaf1559458e"],["org/mockito/session/package-tree.html","0acf3dea0c22e98560325bc8ca7d062d"],["org/mockito/session/package-use.html","f2f6eaa9ae88a918456be1c5846705bf"],["org/mockito/stubbing/Answer.html","d15c0f332b60a31fa59b4c83df69c157"],["org/mockito/stubbing/Answer1.html","ee0540e59945716b372ef172be4994dc"],["org/mockito/stubbing/Answer2.html","907266228a3863a6a4b006c251cbd349"],["org/mockito/stubbing/Answer3.html","46e8f87b8b086105b5de8c627eb4054b"],["org/mockito/stubbing/Answer4.html","1eaed9fff6404e4671b5779b1e55ed37"],["org/mockito/stubbing/Answer5.html","f33820736caea426969d2ae3c2b77591"],["org/mockito/stubbing/OngoingStubbing.html","c8173a7f6c9a2847e2abf5256e509e75"],["org/mockito/stubbing/Stubber.html","7f0cecd6717ce27d9fe384f87ed6c4ec"],["org/mockito/stubbing/Stubbing.html","148d588e7c006344d34a20333a68ccaf"],["org/mockito/stubbing/ValidableAnswer.html","ec04b92c1a19df19adc6568ebd5109e1"],["org/mockito/stubbing/VoidAnswer1.html","938cef2fcf303cb16df9acdc6186cf45"],["org/mockito/stubbing/VoidAnswer2.html","dd250faeb2e82274963c584cadc60bd6"],["org/mockito/stubbing/VoidAnswer3.html","a5e59be64268f948dfa72abb2942ae16"],["org/mockito/stubbing/VoidAnswer4.html","07a62d28338bf377ebfd893a93df17cf"],["org/mockito/stubbing/VoidAnswer5.html","7fc8b860fdccb3641aaeef806fe5160c"],["org/mockito/stubbing/class-use/Answer.html","91c6db33c02026bde5a911e6e857a8bd"],["org/mockito/stubbing/class-use/Answer1.html","0b9bad560bc0e9f9468bfc08d761c338"],["org/mockito/stubbing/class-use/Answer2.html","66a99c578344b16f33a892a9eec38594"],["org/mockito/stubbing/class-use/Answer3.html","e8d174d8452bf19998a3d095fb1c385c"],["org/mockito/stubbing/class-use/Answer4.html","3e5e9f5189c3c4c401036bfe12ff5770"],["org/mockito/stubbing/class-use/Answer5.html","a3fa7d09b82e4c042e7f44724c52af22"],["org/mockito/stubbing/class-use/OngoingStubbing.html","a235c6087857dcd12f5595d60bd273c7"],["org/mockito/stubbing/class-use/Stubber.html","ad42f66df8c56682208ba41b94ef6cb3"],["org/mockito/stubbing/class-use/Stubbing.html","1af97d1c53e6c310bef8a15e4737d77e"],["org/mockito/stubbing/class-use/ValidableAnswer.html","d4113866811615fbab94a90525e76267"],["org/mockito/stubbing/class-use/VoidAnswer1.html","21ff77689d96aa2759c5af6a3e67198a"],["org/mockito/stubbing/class-use/VoidAnswer2.html","9db6a7ec005b452861dc83f40685906a"],["org/mockito/stubbing/class-use/VoidAnswer3.html","d6385d450c3d40182189a6aa046da3c2"],["org/mockito/stubbing/class-use/VoidAnswer4.html","37d6852db8575c90608d869ce40c70a4"],["org/mockito/stubbing/class-use/VoidAnswer5.html","37dedc7e4419d6eba8f88de2379582a5"],["org/mockito/stubbing/package-frame.html","ab319f590ef668931df5fe38f30bb307"],["org/mockito/stubbing/package-summary.html","45bc3a5df54fa3c97ac447d612818444"],["org/mockito/stubbing/package-tree.html","9e9e866e7d4f673635573115694f09dd"],["org/mockito/stubbing/package-use.html","db82e525afa05a5ad32b5549558eb7a4"],["org/mockito/verification/After.html","9914f2766b3e5413cb04532972d30005"],["org/mockito/verification/Timeout.html","a790a029ee3154c2ee1578e14c37738c"],["org/mockito/verification/VerificationAfterDelay.html","72ca7e7539ebb8fc6d875a3d3e77470f"],["org/mockito/verification/VerificationEvent.html","57c7a3327b60e060d9578fee9a6ebead"],["org/mockito/verification/VerificationMode.html","9dca49d3ba8277cb0a6b9e494c60aa75"],["org/mockito/verification/VerificationStrategy.html","18551426426f298ba36c73b52487bc06"],["org/mockito/verification/VerificationWithTimeout.html","c8320808045ace582692a93a340209b3"],["org/mockito/verification/class-use/After.html","152e79eddc7736e50225021d3098a90e"],["org/mockito/verification/class-use/Timeout.html","b7a903884779837859b03a2a346ae446"],["org/mockito/verification/class-use/VerificationAfterDelay.html","8fe392edbccb0ab7ce94229b6e0f8127"],["org/mockito/verification/class-use/VerificationEvent.html","b40e1972acb14579074b189f2536f6c6"],["org/mockito/verification/class-use/VerificationMode.html","654feb424f81fce8650cd686e91e2d17"],["org/mockito/verification/class-use/VerificationStrategy.html","8273d787b0e12a6cd687d18526ab1c0f"],["org/mockito/verification/class-use/VerificationWithTimeout.html","795c56d3098ecda7e8b59809c2d548a2"],["org/mockito/verification/package-frame.html","adb5da5655e9fa7a52cdce62ca1151bd"],["org/mockito/verification/package-summary.html","2c2029484f936034514bacb14d6b3482"],["org/mockito/verification/package-tree.html","544efdbb167ab2dea873584a69c32487"],["org/mockito/verification/package-use.html","e4ffb14682b5746754e59d07b9d4d5fa"],["overview-frame.html","1f73f2dbba185a6890d7812c5f9ae123"],["overview-summary.html","55d31473eafb10705d4d683ec35607df"],["overview-tree.html","a74984366bf31876ce460e4a7cf62591"],["serialized-form.html","38712a8ab60b5408b6f1bf6fbfe688e9"],["stylesheet.css","3dd9013d4309436be79cba586b6e5454"]];
var cacheName = 'sw-precache-v2-sw-precache-' + (self.registration ? self.registration.scope : '');


var ignoreUrlParametersMatching = [/^utm_/];



var addDirectoryIndex = function (originalUrl, index) {
    var url = new URL(originalUrl);
    if (url.pathname.slice(-1) === '/') {
      url.pathname += index;
    }
    return url.toString();
  };

var createCacheKey = function (originalUrl, paramName, paramValue,
                           dontCacheBustUrlsMatching) {
    // Create a new URL object to avoid modifying originalUrl.
    var url = new URL(originalUrl);

    // If dontCacheBustUrlsMatching is not set, or if we don't have a match,
    // then add in the extra cache-busting URL parameter.
    if (!dontCacheBustUrlsMatching ||
        !(url.toString().match(dontCacheBustUrlsMatching))) {
      url.search += (url.search ? '&' : '') +
        encodeURIComponent(paramName) + '=' + encodeURIComponent(paramValue);
    }

    return url.toString();
  };

var isPathWhitelisted = function (whitelist, absoluteUrlString) {
    // If the whitelist is empty, then consider all URLs to be whitelisted.
    if (whitelist.length === 0) {
      return true;
    }

    // Otherwise compare each path regex to the path of the URL passed in.
    var path = (new URL(absoluteUrlString)).pathname;
    return whitelist.some(function(whitelistedPathRegex) {
      return path.match(whitelistedPathRegex);
    });
  };

var stripIgnoredUrlParameters = function (originalUrl,
    ignoreUrlParametersMatching) {
    var url = new URL(originalUrl);

    url.search = url.search.slice(1) // Exclude initial '?'
      .split('&') // Split into an array of 'key=value' strings
      .map(function(kv) {
        return kv.split('='); // Split each 'key=value' string into a [key, value] array
      })
      .filter(function(kv) {
        return ignoreUrlParametersMatching.every(function(ignoredRegex) {
          return !ignoredRegex.test(kv[0]); // Return true iff the key doesn't match any of the regexes.
        });
      })
      .map(function(kv) {
        return kv.join('='); // Join each [key, value] array into a 'key=value' string
      })
      .join('&'); // Join the array of 'key=value' strings into a string with '&' in between each

    return url.toString();
  };


var hashParamName = '_sw-precache';
var urlsToCacheKeys = new Map(
  precacheConfig.map(function(item) {
    var relativeUrl = item[0];
    var hash = item[1];
    var absoluteUrl = new URL(relativeUrl, self.location);
    var cacheKey = createCacheKey(absoluteUrl, hashParamName, hash, false);
    return [absoluteUrl.toString(), cacheKey];
  })
);

function setOfCachedUrls(cache) {
  return cache.keys().then(function(requests) {
    return requests.map(function(request) {
      return request.url;
    });
  }).then(function(urls) {
    return new Set(urls);
  });
}

self.addEventListener('install', function(event) {
  event.waitUntil(
    caches.open(cacheName).then(function(cache) {
      return setOfCachedUrls(cache).then(function(cachedUrls) {
        return Promise.all(
          Array.from(urlsToCacheKeys.values()).map(function(cacheKey) {
            // If we don't have a key matching url in the cache already, add it.
            if (!cachedUrls.has(cacheKey)) {
              return cache.add(new Request(cacheKey, {
                credentials: 'same-origin',
                redirect: 'follow'
              }));
            }
          })
        );
      });
    }).then(function() {
      
      // Force the SW to transition from installing -> active state
      return self.skipWaiting();
      
    })
  );
});

self.addEventListener('activate', function(event) {
  var setOfExpectedUrls = new Set(urlsToCacheKeys.values());

  event.waitUntil(
    caches.open(cacheName).then(function(cache) {
      return cache.keys().then(function(existingRequests) {
        return Promise.all(
          existingRequests.map(function(existingRequest) {
            if (!setOfExpectedUrls.has(existingRequest.url)) {
              return cache.delete(existingRequest);
            }
          })
        );
      });
    }).then(function() {
      
      return self.clients.claim();
      
    })
  );
});


self.addEventListener('fetch', function(event) {
  if (event.request.method === 'GET') {
    // Should we call event.respondWith() inside this fetch event handler?
    // This needs to be determined synchronously, which will give other fetch
    // handlers a chance to handle the request if need be.
    var shouldRespond;

    // First, remove all the ignored parameter and see if we have that URL
    // in our cache. If so, great! shouldRespond will be true.
    var url = stripIgnoredUrlParameters(event.request.url, ignoreUrlParametersMatching);
    shouldRespond = urlsToCacheKeys.has(url);

    // If shouldRespond is false, check again, this time with 'index.html'
    // (or whatever the directoryIndex option is set to) at the end.
    var directoryIndex = 'index.html';
    if (!shouldRespond && directoryIndex) {
      url = addDirectoryIndex(url, directoryIndex);
      shouldRespond = urlsToCacheKeys.has(url);
    }

    // If shouldRespond is still false, check to see if this is a navigation
    // request, and if so, whether the URL matches navigateFallbackWhitelist.
    var navigateFallback = '';
    if (!shouldRespond &&
        navigateFallback &&
        (event.request.mode === 'navigate') &&
        isPathWhitelisted([], event.request.url)) {
      url = new URL(navigateFallback, self.location).toString();
      shouldRespond = urlsToCacheKeys.has(url);
    }

    // If shouldRespond was set to true at any point, then call
    // event.respondWith(), using the appropriate cache key.
    if (shouldRespond) {
      event.respondWith(
        caches.open(cacheName).then(function(cache) {
          return cache.match(urlsToCacheKeys.get(url)).then(function(response) {
            if (response) {
              return response;
            }
            throw Error('The cached response that was expected is missing.');
          });
        }).catch(function(e) {
          // Fall back to just fetch()ing the request if some unexpected error
          // prevented the cached response from being valid.
          console.warn('Couldn\'t serve response for "%s" from cache: %O', event.request.url, e);
          return fetch(event.request);
        })
      );
    }
  }
});







