/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.io.UnsupportedEncodingException;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPAuthentication;
import org.tmatesoft.svn.core.internal.util.SVNBase64;

class HTTPBasicAuthentication
extends HTTPAuthentication {
    private String myCharset;

    public HTTPBasicAuthentication(SVNPasswordAuthentication credentials, String charset) {
        super(credentials);
        this.myCharset = charset;
    }

    protected HTTPBasicAuthentication(String name, String password, String charset) {
        super(name, password);
        this.myCharset = charset;
    }

    protected HTTPBasicAuthentication(String charset) {
        this.myCharset = charset;
    }

    public String authenticate() {
        if (this.getUserName() == null || this.getPassword() == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        String authStr = this.getUserName() + ":" + this.getPassword();
        try {
            authStr = SVNBase64.byteArrayToBase64(authStr.getBytes(this.myCharset));
        }
        catch (UnsupportedEncodingException e) {
            authStr = SVNBase64.byteArrayToBase64(authStr.getBytes());
        }
        result.append("Basic ");
        result.append(authStr);
        return result.toString();
    }

    public String getAuthenticationScheme() {
        return "Basic";
    }
}

