/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

public class RuntimeUtil {
    public static final Runtime RUNTIME = Runtime.getRuntime();

    public static String currentMethod() {
        StackTraceElement[] ste = new Exception().getStackTrace();
        int ndx = ste.length > 1 ? 1 : 0;
        return new Exception().getStackTrace()[ndx].toString();
    }

    public static long availableMemory() {
        return RUNTIME.freeMemory() + (RUNTIME.maxMemory() - RUNTIME.totalMemory());
    }

    public static float availableMemoryPercent() {
        return (float)RuntimeUtil.availableMemory() * 100.0f / (float)RUNTIME.maxMemory();
    }

    public static void compactMemory() {
        try {
            byte[][] unused = new byte[128][];
            int i = unused.length;
            while (i-- != 0) {
                unused[i] = new byte[2000000000];
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        System.gc();
    }
}

