/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jodd.mail.CommonEmail;
import jodd.mail.EmailAttachment;
import jodd.mail.att.ByteArrayAttachment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReceivedEmail
extends CommonEmail {
    public static final int ANSWERED = 1;
    public static final int DELETED = 2;
    public static final int DRAFT = 4;
    public static final int FLAGGED = 8;
    public static final int RECENT = 16;
    public static final int SEEN = 32;
    public static final int USER = Integer.MIN_VALUE;
    protected int messageNumber;
    protected int flags;
    protected Date recvDate;
    protected List<EmailAttachment> attachments;

    public int getMessageNumber() {
        return this.messageNumber;
    }

    public void setMessageNumber(int messageNumber) {
        this.messageNumber = messageNumber;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public void addFlags(int flag) {
        this.flags |= flag;
    }

    public void removeFlags(int flag) {
        this.flags &= ~flag;
    }

    public boolean hasFlags(int flags) {
        return (this.flags & flags) != 0;
    }

    public void setReceiveDate(Date date) {
        this.recvDate = date;
    }

    public Date getReceiveDate() {
        return this.recvDate;
    }

    public void addAttachment(String filename, String mimeType, String contentId, byte[] content) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<EmailAttachment>();
        }
        ByteArrayAttachment emailAttachment = new ByteArrayAttachment(content, mimeType, filename, contentId);
        emailAttachment.setSize(content.length);
        this.attachments.add(emailAttachment);
    }

    public List<EmailAttachment> getAttachments() {
        return this.attachments;
    }
}

