/*
 * Decompiled with CFR 0.152.
 */
package jodd.io.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jodd.io.StreamUtil;
import jodd.io.http.Http;
import jodd.io.http.HttpTransfer;

public class HttpTunnel {
    protected int threadPoolSize = 10;
    protected int socketBacklog = 100;
    protected int listenPort = 8888;
    protected String targetHost = "localhost";
    protected int targetPort = 8080;
    protected ExecutorService executorService;
    protected boolean running;
    protected ServerSocket serverSocket;

    public void start() throws IOException {
        this.serverSocket = new ServerSocket(this.listenPort, this.socketBacklog);
        this.serverSocket.setReuseAddress(true);
        this.executorService = Executors.newFixedThreadPool(this.threadPoolSize);
        this.running = true;
        while (this.running) {
            Socket socket = this.serverSocket.accept();
            socket.setKeepAlive(false);
            this.executorService.execute(this.onSocketConnection(socket));
        }
        this.executorService.shutdown();
    }

    protected Runnable onSocketConnection(Socket socket) {
        return new HttpTunnelConnection(socket);
    }

    public void stop() {
        this.running = false;
        this.executorService.shutdown();
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public class HttpTunnelConnection
    implements Runnable {
        protected final Socket socket;

        public HttpTunnelConnection(Socket socket) {
            this.socket = socket;
        }

        public void run() {
            try {
                this.tunnel();
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
            }
        }

        protected void onRequest(HttpTransfer request) {
        }

        protected void onResponse(HttpTransfer response) {
        }

        protected void tunnel() throws IOException {
            InputStream socketInput = this.socket.getInputStream();
            HttpTransfer request = Http.readRequest(socketInput);
            Socket clientSocket = new Socket();
            clientSocket.connect(new InetSocketAddress(HttpTunnel.this.targetHost, HttpTunnel.this.targetPort));
            this.onRequest(request);
            OutputStream out = clientSocket.getOutputStream();
            request.send(out);
            InputStream in = clientSocket.getInputStream();
            HttpTransfer response = Http.readResponse(in);
            StreamUtil.close(in);
            StreamUtil.close(out);
            clientSocket.close();
            if (response.getBody() != null) {
                response.removeHeader("Transfer-Encoding");
                response.addHeader("Content-Length", response.getBody().length);
            }
            this.onResponse(response);
            OutputStream socketOutput = this.socket.getOutputStream();
            response.send(socketOutput);
            StreamUtil.close(socketInput);
            StreamUtil.close(socketOutput);
            this.socket.close();
        }
    }
}

