/*
 * Decompiled with CFR 0.152.
 */
package jodd.io.findfile;

import java.io.File;

public abstract class FileScanner {
    protected boolean recursive;
    protected boolean includeDirs = true;
    protected boolean includeFiles = true;

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public boolean isIncludeDirs() {
        return this.includeDirs;
    }

    public void setIncludeDirs(boolean includeDirs) {
        this.includeDirs = includeDirs;
    }

    public boolean isIncludeFiles() {
        return this.includeFiles;
    }

    public void setIncludeFiles(boolean includeFiles) {
        this.includeFiles = includeFiles;
    }

    public void scan(File root) {
        File[] allFiles = root.listFiles();
        if (allFiles == null) {
            return;
        }
        for (File file : allFiles) {
            this.process(file);
        }
    }

    public void scan(String string) {
        this.scan(new File(string));
    }

    protected void process(File file) {
        boolean isFolder = file.isDirectory();
        if (isFolder) {
            if (this.includeDirs) {
                this.onFile(file);
            }
            if (this.recursive && this.acceptFolder(file)) {
                this.scan(file);
            }
            return;
        }
        if (this.includeFiles) {
            this.onFile(file);
        }
    }

    protected boolean acceptFolder(File file) {
        return true;
    }

    protected abstract void onFile(File var1);
}

