/*
 * Decompiled with CFR 0.152.
 */
package jodd.introspector;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jodd.introspector.MethodDescriptor;
import jodd.introspector.MethodEntry;
import jodd.util.ReflectUtil;

class Methods {
    HashMap<String, List<MethodDescriptor>> mMapTemp = new HashMap();
    HashMap<String, MethodEntry> mMap = new HashMap();
    Method[] allMethods;
    boolean locked;
    int count;

    Methods() {
    }

    void checkLocked() {
        if (this.locked) {
            throw new IllegalStateException("Methods introspection is already finished.");
        }
    }

    void addMethod(String name, Method method) {
        this.checkLocked();
        ++this.count;
        List<MethodDescriptor> paramList = this.mMapTemp.get(name);
        if (paramList == null) {
            paramList = new ArrayList<MethodDescriptor>();
            this.mMapTemp.put(name, paramList);
        }
        paramList.add(new MethodDescriptor(method));
    }

    void lock() {
        HashMap<String, MethodEntry> newMap = new HashMap<String, MethodEntry>(this.mMapTemp.size());
        this.locked = true;
        this.allMethods = new Method[this.count];
        int k = 0;
        for (String name : this.mMapTemp.keySet()) {
            List<MethodDescriptor> list = this.mMapTemp.get(name);
            if (list.isEmpty()) continue;
            MethodEntry entry = new MethodEntry();
            entry.size = list.size();
            entry.methodsList = new Method[entry.size];
            entry.paramterTypes = new Class[entry.size][];
            for (int i = 0; i < entry.size; ++i) {
                MethodDescriptor md = list.get(i);
                this.allMethods[k] = md.method;
                ++k;
                entry.methodsList[i] = md.method;
                entry.paramterTypes[i] = md.parameterTypes;
            }
            newMap.put(name, entry);
        }
        this.mMap = newMap;
        this.mMapTemp = null;
    }

    Method getMethod(String name, Class[] paramTypes) {
        MethodEntry entry = this.mMap.get(name);
        if (entry == null) {
            return null;
        }
        for (int i = 0; i < entry.size; ++i) {
            if (!ReflectUtil.compareParameters(entry.paramterTypes[i], paramTypes)) continue;
            return entry.methodsList[i];
        }
        return null;
    }

    Method getMethod(String name) {
        MethodEntry entry = this.mMap.get(name);
        if (entry == null) {
            return null;
        }
        if (entry.size != 1) {
            throw new IllegalArgumentException("Method '" + name + "' is not unique!");
        }
        return entry.methodsList[0];
    }

    Method[] getAllMethods(String name) {
        MethodEntry entry = this.mMap.get(name);
        if (entry == null) {
            return null;
        }
        return entry.methodsList;
    }

    Method[] getAllMethods() {
        return this.allMethods;
    }

    Method lookupMethod(String name, Class[] paramTypes) {
        this.checkLocked();
        List<MethodDescriptor> list = this.mMapTemp.get(name);
        if (list == null) {
            return null;
        }
        for (MethodDescriptor md : list) {
            if (!ReflectUtil.compareParameters(md.parameterTypes, paramTypes)) continue;
            return md.method;
        }
        return null;
    }

    public void removeAllMethodsForName(String name) {
        this.checkLocked();
        List<MethodDescriptor> paramList = this.mMapTemp.remove(name);
        if (paramList != null) {
            this.count -= paramList.size();
        }
    }
}

