/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.parser;

import com.icesoft.jasper.JasperException;
import com.icesoft.jasper.compiler.TldLocationsCache;
import com.icesoft.jasper.xmlparser.ParserUtils;
import com.icesoft.jasper.xmlparser.TreeNode;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JspPageToDocument {
    static String JSP_TAGLIB_PATTERN = "<%@\\s*taglib\\s+(.*?)%>";
    static String URI_PATTERN = "uri=\"(.*?)\"";
    static String PREFIX_PATTERN = "prefix=\"(.*?)\"";
    static String JSP_DECL_PATTERN = "<%.*?%>";
    static String STATIC_INCLUDE_PATTERN = "<%@\\s*include\\s+file=\"([^\"]*)\".*?%>";
    static String STATIC_INCLUDE_DIRECTIVE_PATTERN = "<\\s*jsp:directive.include\\s+file=\"([^\"]*)\".*?/>";
    static String OPEN_TAG_PATTERN = "<\\s*(\\w*\\:*\\w+)([^>]*)>";
    static String GENERIC_TAG_PATTERN = "(<\\s*)(/*)(\\w+)([^:])";
    static String ATTRIBUTE_PATTERN = "\\s*([^=]*)\\s*=\\s*\"([^\"]*)\"";
    static String HTML_TAG_PATTERN = "<\\s*html";
    static String P_TAG_PATTERN = "<\\s*/*(p)([^>]*?)/*>";
    static String IMG_TAG_PATTERN = "<\\s*(img)([^>]*?)/*>";
    static String JSP_INCLUDE_PATTERN = "<\\s*jsp:include([^>]*?)/>";
    static String BR_TAG_PATTERN = "<\\s*br\\s*>";
    static String HR_TAG_PATTERN = "<\\s*hr\\s*>";
    static String LINK_TAG_PATTERN = "<\\s*(link)([^>]*?)/*>";
    static String META_TAG_PATTERN = "<\\s*(meta)([^>]*?)/*>";
    static String INPUT_TAG_PATTERN = "<\\s*(input)([^>]*?)/*>";
    static String NBSP_ENTITY_PATTERN = "&nbsp";
    static String COPY_ENTITY_PATTERN = "&copy;";
    static String DOC_DECL_PATTERN = "<!DOCTYPE [^>]*>";
    static String XML_DECL_PATTERN = "<\\?xml [^>]*\\?>";
    static String MYFACES_TAG_CLASS = "org/apache/myfaces/taglib/core/ViewTag.class";
    static String SUN_TAG_CLASS = "com/sun/faces/taglib/jsf_core/ViewTag.class";
    static String HTML_TLD_SUFFIX = "META-INF/html_basic.tld";
    static String CORE_TLD_SUFFIX = "META-INF/jsf_core.tld";
    private static final Log log = LogFactory.getLog((Class)JspPageToDocument.class);

    public static void main(String[] args) {
        try {
            JspPageToDocument.getInputAsString(JspPageToDocument.transform(new FileReader(args[0])));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String transform(String input) {
        String result = input;
        Pattern jspDeclarationPattern = Pattern.compile(JSP_DECL_PATTERN, 32);
        Matcher jspDeclarationMatcher = jspDeclarationPattern.matcher(result);
        if (!jspDeclarationMatcher.find()) {
            return JspPageToDocument.preprocessJspDocument(result);
        }
        result = JspPageToDocument.performStaticInclude(STATIC_INCLUDE_PATTERN, input);
        result = JspPageToDocument.toLowerHTML(result);
        Pattern jspTaglibPattern = Pattern.compile(JSP_TAGLIB_PATTERN, 32);
        Pattern openTagPattern = Pattern.compile(OPEN_TAG_PATTERN, 32);
        Pattern attributePattern = Pattern.compile(ATTRIBUTE_PATTERN, 32);
        Pattern prefixPattern = Pattern.compile(PREFIX_PATTERN, 32);
        Pattern uriPattern = Pattern.compile(URI_PATTERN, 32);
        Hashtable<String, String> declarationsTable = new Hashtable<String, String>();
        Matcher jspTaglibMatcher = jspTaglibPattern.matcher(result);
        declarationsTable.put("xmlns:jsp", "jsp");
        declarationsTable.put("xmlns:icefaces", "http://www.icesoft.com/icefaces");
        while (jspTaglibMatcher.find()) {
            String attributes = jspTaglibMatcher.group(1);
            Matcher prefixMatcher = prefixPattern.matcher(attributes);
            Matcher uriMatcher = uriPattern.matcher(attributes);
            prefixMatcher.find();
            uriMatcher.find();
            String prefix = prefixMatcher.group(1);
            String url = uriMatcher.group(1);
            declarationsTable.put("xmlns:" + prefix, url);
        }
        Matcher openTagMatcher = openTagPattern.matcher(result);
        openTagMatcher.find();
        String tag = openTagMatcher.group(1);
        String attributes = openTagMatcher.group(2);
        Matcher attributeMatcher = attributePattern.matcher(attributes);
        while (attributeMatcher.find()) {
            String name = attributeMatcher.group(1);
            String value = attributeMatcher.group(2);
            declarationsTable.put(name, value);
        }
        Enumeration declarations = declarationsTable.keys();
        String namespaceDeclarations = "";
        while (declarations.hasMoreElements()) {
            String prefix = (String)declarations.nextElement();
            String url = (String)declarationsTable.get(prefix);
            namespaceDeclarations = namespaceDeclarations + prefix + "=\"" + url + "\" ";
        }
        jspDeclarationMatcher = jspDeclarationPattern.matcher(result);
        result = jspDeclarationMatcher.replaceAll("");
        result = "<icefaces:root " + namespaceDeclarations + ">" + result + "</icefaces:root>";
        Pattern jspIncludePattern = Pattern.compile(JSP_INCLUDE_PATTERN);
        Matcher jspIncludeMatcher = jspIncludePattern.matcher(result);
        StringBuffer jspIncludeBuf = new StringBuffer();
        while (jspIncludeMatcher.find()) {
            String args = jspIncludeMatcher.group(1);
            jspIncludeMatcher.appendReplacement(jspIncludeBuf, "<icefaces:include" + args + " isDynamic=\"#{true}\" />");
        }
        jspIncludeMatcher.appendTail(jspIncludeBuf);
        result = jspIncludeBuf.toString();
        result = JspPageToDocument.toSingletonTag(P_TAG_PATTERN, result);
        result = JspPageToDocument.toSingletonTag(LINK_TAG_PATTERN, result);
        result = JspPageToDocument.toSingletonTag(META_TAG_PATTERN, result);
        result = JspPageToDocument.toSingletonTag(IMG_TAG_PATTERN, result);
        result = JspPageToDocument.toSingletonTag(INPUT_TAG_PATTERN, result);
        Pattern brTagPattern = Pattern.compile(BR_TAG_PATTERN);
        Matcher brTagMatcher = brTagPattern.matcher(result);
        result = brTagMatcher.replaceAll("<br/>");
        Pattern hrTagPattern = Pattern.compile(HR_TAG_PATTERN);
        Matcher hrTagMatcher = hrTagPattern.matcher(result);
        result = hrTagMatcher.replaceAll("<hr/>");
        Pattern nbspEntityPattern = Pattern.compile(NBSP_ENTITY_PATTERN);
        Matcher nbspEntityMatcher = nbspEntityPattern.matcher(result);
        result = nbspEntityMatcher.replaceAll("&amp;nbsp");
        Pattern copyEntityPattern = Pattern.compile(COPY_ENTITY_PATTERN);
        Matcher copyEntityMatcher = copyEntityPattern.matcher(result);
        result = copyEntityMatcher.replaceAll("&#169;");
        Pattern docDeclPattern = Pattern.compile(DOC_DECL_PATTERN);
        Matcher docDeclMatcher = docDeclPattern.matcher(result);
        result = docDeclMatcher.replaceAll("");
        result = JspPageToDocument.unescapeBackslash(result);
        return result;
    }

    static String preprocessJspDocument(String input) {
        String result = input;
        result = JspPageToDocument.performStaticInclude(STATIC_INCLUDE_DIRECTIVE_PATTERN, input);
        return result;
    }

    public static Reader preprocessJspDocument(Reader input) {
        String inputString = JspPageToDocument.getInputAsString(input);
        String outputString = JspPageToDocument.preprocessJspDocument(inputString);
        return new StringReader(outputString);
    }

    static String performStaticInclude(String includePatternString, String input) {
        String result = input;
        boolean matchFound = true;
        Pattern staticIncludePattern = Pattern.compile(includePatternString);
        while (matchFound) {
            matchFound = false;
            StringBuffer staticIncludeBuf = new StringBuffer();
            Matcher staticIncludeMatcher = staticIncludePattern.matcher(result);
            while (staticIncludeMatcher.find()) {
                matchFound = true;
                String args = staticIncludeMatcher.group(1);
                try {
                    if (!args.startsWith("/")) {
                        String servletPath = FacesContext.getCurrentInstance().getExternalContext().getRequestServletPath();
                        String workingDir = servletPath.substring(0, servletPath.lastIndexOf("/"));
                        args = workingDir + "/" + args;
                    }
                    String includeString = JspPageToDocument.getInputAsString(new InputStreamReader(FacesContext.getCurrentInstance().getExternalContext().getResource(args).openConnection().getInputStream()));
                    Pattern xmlDeclPattern = Pattern.compile(XML_DECL_PATTERN);
                    Matcher xmlDeclMatcher = xmlDeclPattern.matcher(includeString);
                    includeString = xmlDeclMatcher.replaceAll("");
                    staticIncludeMatcher.appendReplacement(staticIncludeBuf, JspPageToDocument.escapeBackreference(includeString));
                }
                catch (Exception e) {
                    staticIncludeMatcher.appendReplacement(staticIncludeBuf, "");
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)("static include failed to include " + args), (Throwable)e);
                }
            }
            staticIncludeMatcher.appendTail(staticIncludeBuf);
            result = staticIncludeBuf.toString();
        }
        return result;
    }

    static String toSingletonTag(String pattern, String input) {
        Pattern tagPattern = Pattern.compile(pattern, 32);
        Matcher tagMatcher = tagPattern.matcher(input);
        StringBuffer tagBuf = new StringBuffer();
        while (tagMatcher.find()) {
            String tagName = tagMatcher.group(1);
            String attributes = tagMatcher.group(2);
            tagMatcher.appendReplacement(tagBuf, JspPageToDocument.escapeBackreference("<" + tagName + attributes + "/>"));
        }
        tagMatcher.appendTail(tagBuf);
        return tagBuf.toString();
    }

    public static String toLowerHTML(String input) {
        Pattern genericPattern = Pattern.compile(GENERIC_TAG_PATTERN);
        Matcher genericMatcher = genericPattern.matcher(input);
        StringBuffer inputBuffer = new StringBuffer();
        while (genericMatcher.find()) {
            String openBracket = genericMatcher.group(1);
            String slash = genericMatcher.group(2);
            String tagName = genericMatcher.group(3);
            String trailing = genericMatcher.group(4);
            if (!"HTML".equals(tagName)) {
                tagName = tagName.toLowerCase();
            }
            genericMatcher.appendReplacement(inputBuffer, JspPageToDocument.escapeBackreference(openBracket + slash + tagName + trailing));
        }
        genericMatcher.appendTail(inputBuffer);
        return inputBuffer.toString();
    }

    public static String escapeBackreference(String input) {
        String result = input;
        Pattern slashPattern = Pattern.compile("\\\\");
        Matcher slashMatcher = slashPattern.matcher(result);
        result = slashMatcher.replaceAll("\\\\\\\\");
        Pattern dollarPattern = Pattern.compile("\\$");
        Matcher dollarMatcher = dollarPattern.matcher(result);
        result = dollarMatcher.replaceAll("\\\\\\$");
        return result;
    }

    public static String unescapeBackslash(String input) {
        String result = input;
        Pattern slashPattern = Pattern.compile("\\\\\\\\");
        Matcher slashMatcher = slashPattern.matcher(result);
        result = slashMatcher.replaceAll("\\\\");
        return result;
    }

    public static Reader transform(Reader input) {
        String inputString = JspPageToDocument.getInputAsString(input);
        String outputString = JspPageToDocument.transform(inputString);
        if (log.isTraceEnabled()) {
            log.trace((Object)outputString);
        }
        return new StringReader(outputString);
    }

    public static InputStream getTldInputStream(ExternalContext context, String namespaceURL) throws IOException {
        URLConnection conn;
        URL tagURL;
        String[] location;
        JarFile jarFile;
        block34: {
            block33: {
                jarFile = null;
                location = null;
                if ("jsp".equals(namespaceURL = String.valueOf(namespaceURL))) {
                    return null;
                }
                if ("http://java.sun.com/JSP/Page".equals(namespaceURL)) {
                    return null;
                }
                TldLocationsCache tldCache = new TldLocationsCache(context);
                try {
                    location = tldCache.getLocation(namespaceURL);
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block33;
                    log.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (null == location && namespaceURL.startsWith("/") && namespaceURL.endsWith(".tld")) {
                location = new String[]{namespaceURL};
            }
            if (null == location) {
                location = JspPageToDocument.scanJars(context, namespaceURL);
            }
            if (null == location && null != (tagURL = JspPageToDocument.class.getClassLoader().getResource(SUN_TAG_CLASS))) {
                conn = tagURL.openConnection();
                if (tagURL.getProtocol().equals("vfszip")) {
                    String jarPath;
                    String tagPath = tagURL.toExternalForm();
                    String tldPath = jarPath = tagPath.substring(0, tagPath.indexOf(SUN_TAG_CLASS));
                    if (namespaceURL.endsWith("html")) {
                        tldPath = tldPath + HTML_TLD_SUFFIX;
                    } else if (namespaceURL.endsWith("core")) {
                        tldPath = tldPath + CORE_TLD_SUFFIX;
                    }
                    URL tldURL = new URL(tldPath);
                    return tldURL.openConnection().getInputStream();
                }
                if (conn instanceof JarURLConnection) {
                    location = JspPageToDocument.scanJar((JarURLConnection)conn, namespaceURL);
                } else if (namespaceURL.endsWith("html")) {
                    location = JspPageToDocument.getBundleLocation(tagURL, HTML_TLD_SUFFIX);
                } else if (namespaceURL.endsWith("core")) {
                    location = JspPageToDocument.getBundleLocation(tagURL, CORE_TLD_SUFFIX);
                }
            }
            if (null == location) {
                try {
                    String separator = System.getProperty("path.separator");
                    String wsDirs = System.getProperty("ws.ext.dirs");
                    String[] dirs = null;
                    dirs = null != wsDirs ? wsDirs.split(separator) : new String[]{};
                    Iterator<String> theDirs = Arrays.asList(dirs).iterator();
                    while (theDirs.hasNext()) {
                        String dir = theDirs.next();
                        try {
                            location = JspPageToDocument.scanJars(dir, namespaceURL);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (null == location) continue;
                        break;
                    }
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block34;
                    log.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        if (null == location && null != (tagURL = JspPageToDocument.class.getClassLoader().getResource(MYFACES_TAG_CLASS))) {
            conn = tagURL.openConnection();
            if (conn instanceof JarURLConnection) {
                location = JspPageToDocument.scanJar((JarURLConnection)conn, namespaceURL);
            } else if (namespaceURL.endsWith("html")) {
                location = JspPageToDocument.getBundleLocation(tagURL, HTML_TLD_SUFFIX);
            } else if (namespaceURL.endsWith("core")) {
                location = JspPageToDocument.getBundleLocation(tagURL, CORE_TLD_SUFFIX);
            }
        }
        if (null == location) {
            String msg = "Can't find TLD for location [" + namespaceURL + "]. JAR containing the TLD may not be in the classpath";
            log.error((Object)msg);
            return null;
        }
        if (log.isTraceEnabled()) {
            for (int i = 0; i < location.length; ++i) {
                log.trace((Object)("Found TLD location for " + namespaceURL + " = " + location[i]));
            }
        }
        if (!location[0].endsWith("jar")) {
            InputStream tldStream = context.getResourceAsStream(location[0]);
            if (null == tldStream) {
                tldStream = new URL(location[0]).openConnection().getInputStream();
            }
            return tldStream;
        }
        URL jarFileUrl = new URL("jar:" + location[0] + "!/");
        conn = (JarURLConnection)jarFileUrl.openConnection();
        conn.setUseCaches(false);
        conn.connect();
        jarFile = ((JarURLConnection)conn).getJarFile();
        ZipEntry jarEntry = jarFile.getEntry(location[1]);
        return jarFile.getInputStream(jarEntry);
    }

    private static String[] getBundleLocation(URL url, String path) {
        String protocol = url.getProtocol();
        String host = url.getHost();
        String port = String.valueOf(url.getPort());
        String urlString = protocol + "://" + host + ":" + port + "/" + path;
        return new String[]{urlString, null};
    }

    public static InputStream stripDoctype(InputStream source) {
        String result = JspPageToDocument.getInputAsString(new InputStreamReader(source));
        Pattern docDeclPattern = Pattern.compile(DOC_DECL_PATTERN);
        Matcher docDeclMatcher = docDeclPattern.matcher(result);
        result = docDeclMatcher.replaceAll("");
        return new StringBufferInputStream(result);
    }

    static String getInputAsString(Reader in) {
        StringWriter out;
        block3: {
            char[] buf = new char[1024];
            out = new StringWriter();
            try {
                int l = 1;
                while (l > 0) {
                    l = in.read(buf);
                    if (l <= 0) continue;
                    out.write(buf, 0, l);
                }
            }
            catch (IOException e) {
                if (!log.isWarnEnabled()) break block3;
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        return out.toString();
    }

    static String[] scanJars(ExternalContext context, String namespaceURL) {
        block3: {
            try {
                String[] location = null;
                Iterator paths = context.getResourcePaths("/WEB-INF/lib/").iterator();
                while (paths.hasNext()) {
                    String path = (String)paths.next();
                    if (!path.endsWith(".jar")) continue;
                    path = context.getResource(path).toString();
                    JarURLConnection connection = (JarURLConnection)new URL("jar:" + path + "!/").openConnection();
                    location = JspPageToDocument.scanJar(connection, namespaceURL);
                    if (null == location) continue;
                    return location;
                }
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block3;
                log.warn((Object)("Jar scanning under /WEB_INF/lib failed " + e.getMessage()), (Throwable)e);
            }
        }
        return null;
    }

    static String[] scanJars(String dir, String namespaceURL) throws IOException {
        String[] location = null;
        Iterator<File> paths = Arrays.asList(new File(dir).listFiles()).iterator();
        while (paths.hasNext()) {
            URL url;
            JarURLConnection connection;
            String path = paths.next().getCanonicalPath();
            if (!path.endsWith(".jar") || null == (location = JspPageToDocument.scanJar(connection = (JarURLConnection)(url = new URL("jar:file:" + path + "!/")).openConnection(), namespaceURL))) continue;
            return location;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String[] scanJar(JarURLConnection conn, String namespaceURL) throws IOException {
        JarFile jarFile = null;
        String resourcePath = conn.getJarFileURL().toString();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Fallback Scanning Jar " + resourcePath));
        }
        jarFile = conn.getJarFile();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            try {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith("META-INF/") || !name.endsWith(".tld")) continue;
                InputStream stream = jarFile.getInputStream(entry);
                try {
                    String uri = JspPageToDocument.getUriFromTld(resourcePath, stream);
                    if (uri == null || !uri.equals(namespaceURL)) continue;
                    String[] stringArray = new String[]{resourcePath, name};
                    return stringArray;
                }
                catch (JasperException jpe) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)jpe.getMessage(), (Throwable)((Object)jpe));
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)t.getMessage(), t);
            }
        }
        return null;
    }

    static String getUriFromTld(String resourcePath, InputStream in) throws JasperException {
        String body;
        TreeNode tld = new ParserUtils().parseXMLDocument(resourcePath, in);
        TreeNode uri = tld.findChild("uri");
        if (uri != null && (body = uri.getBody()) != null) {
            return body;
        }
        return null;
    }
}

