/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.util.event.servlet;

import com.icesoft.faces.util.event.servlet.AnnouncementMessageHandler;
import com.icesoft.faces.util.event.servlet.ContextDestroyedEvent;
import com.icesoft.faces.util.event.servlet.ContextEvent;
import com.icesoft.faces.util.event.servlet.ContextEventListener;
import com.icesoft.faces.util.event.servlet.ICEfacesIDDisposedEvent;
import com.icesoft.faces.util.event.servlet.ICEfacesIDRetrievedEvent;
import com.icesoft.faces.util.event.servlet.SessionDestroyedEvent;
import com.icesoft.faces.util.event.servlet.ViewNumberDisposedEvent;
import com.icesoft.faces.util.event.servlet.ViewNumberRetrievedEvent;
import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.servlet.ServletContextConfiguration;
import com.icesoft.faces.webapp.http.servlet.SessionDispatcher;
import com.icesoft.net.messaging.MessageServiceClient;
import com.icesoft.net.messaging.MessageServiceException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContextEventRepeater
implements HttpSessionListener,
ServletContextListener {
    private static final Log LOG = LogFactory.getLog((Class)ContextEventRepeater.class);
    private static final String BUFFERED_CONTEXT_EVENTS_MESSAGE_TYPE = "BufferedContextEvents";
    private static final String CONTEXT_EVENT_MESSAGE_TYPE = "ContextEvent";
    private static SessionDispatcher.Listener SessionDispatcherListener = new SessionDispatcher.Listener();
    private static List bufferedContextEvents = new ArrayList();
    private static Map listeners = new WeakHashMap();
    private static Configuration servletContextConfiguration;
    private static String blockingRequestHandlerContext;
    private static MessageServiceClient messageServiceClient;
    private static AnnouncementMessageHandler announcementMessageHandler;

    public static synchronized void addListener(ContextEventListener contextEventListener) {
        if (contextEventListener == null || listeners.containsKey(contextEventListener)) {
            return;
        }
        listeners.put(contextEventListener, null);
        if (contextEventListener.receiveBufferedEvents()) {
            ContextEventRepeater.sendBufferedEvents(contextEventListener);
        }
    }

    public synchronized void contextDestroyed(ServletContextEvent event) {
        SessionDispatcherListener.contextDestroyed(event);
        ContextDestroyedEvent contextDestroyedEvent = new ContextDestroyedEvent(event);
        Iterator it = listeners.keySet().iterator();
        while (it.hasNext()) {
            ((ContextEventListener)it.next()).contextDestroyed(contextDestroyedEvent);
        }
        listeners.clear();
        bufferedContextEvents.clear();
        if (LOG.isInfoEnabled()) {
            ServletContext servletContext = contextDestroyedEvent.getServletContext();
            LOG.info((Object)("Servlet Context Name: " + servletContext.getServletContextName() + ", " + "Server Info: " + servletContext.getServerInfo()));
        }
    }

    public synchronized void contextInitialized(ServletContextEvent event) {
        servletContextConfiguration = new ServletContextConfiguration("com.icesoft.faces", event.getServletContext());
        SessionDispatcherListener.contextInitialized(event);
    }

    public static synchronized void iceFacesIdDisposed(Object source, String iceFacesId) {
        ICEfacesIDDisposedEvent iceFacesIdDisposedEvent = new ICEfacesIDDisposedEvent(source, iceFacesId);
        Iterator _listeners = listeners.keySet().iterator();
        while (_listeners.hasNext()) {
            ((ContextEventListener)_listeners.next()).iceFacesIdDisposed(iceFacesIdDisposedEvent);
        }
        ContextEventRepeater.removeBufferedEvents(iceFacesId);
        if (messageServiceClient != null) {
            com.icesoft.util.Properties _messageProperties = new com.icesoft.util.Properties();
            _messageProperties.setStringProperty("destination_servletContextPath", blockingRequestHandlerContext);
            messageServiceClient.publish(ContextEventRepeater.createMessage(iceFacesIdDisposedEvent), (Properties)_messageProperties, CONTEXT_EVENT_MESSAGE_TYPE, "icefacesPush");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("ICEfaces ID disposed: " + iceFacesIdDisposedEvent.getICEfacesID()));
        }
    }

    public static synchronized void iceFacesIdRetrieved(Object source, String iceFacesId) {
        ICEfacesIDRetrievedEvent iceFacesIdRetrievedEvent = new ICEfacesIDRetrievedEvent(source, iceFacesId);
        bufferedContextEvents.add(iceFacesIdRetrievedEvent);
        Iterator _listeners = listeners.keySet().iterator();
        while (_listeners.hasNext()) {
            ((ContextEventListener)_listeners.next()).iceFacesIdRetrieved(iceFacesIdRetrievedEvent);
        }
        if (messageServiceClient != null) {
            com.icesoft.util.Properties _messageProperties = new com.icesoft.util.Properties();
            _messageProperties.setStringProperty("destination_servletContextPath", blockingRequestHandlerContext);
            messageServiceClient.publish(ContextEventRepeater.createMessage(iceFacesIdRetrievedEvent), (Properties)_messageProperties, CONTEXT_EVENT_MESSAGE_TYPE, "icefacesPush");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("ICEfaces ID retrieved: " + iceFacesIdRetrievedEvent.getICEfacesID()));
        }
    }

    public static synchronized void removeListener(ContextEventListener contextEventListener) {
        if (contextEventListener == null) {
            return;
        }
        listeners.remove(contextEventListener);
    }

    public synchronized void sessionCreated(HttpSessionEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Session Created event: " + event.getSession().getId()));
        }
    }

    public synchronized void sessionDestroyed(HttpSessionEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Session Destroyed event: " + event.getSession().getId()));
        }
        SessionDispatcherListener.sessionDestroyed(event);
        SessionDestroyedEvent sessionDestroyedEvent = new SessionDestroyedEvent(event);
        Iterator _listeners = listeners.keySet().iterator();
        while (_listeners.hasNext()) {
            ((ContextEventListener)_listeners.next()).sessionDestroyed(sessionDestroyedEvent);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("ICEfaces ID: " + sessionDestroyedEvent.getICEfacesID()));
        }
    }

    public static synchronized void setMessageServiceClient(MessageServiceClient client) {
        if (client != null) {
            blockingRequestHandlerContext = servletContextConfiguration.getAttribute("blockingRequestHandlerContext", "push-server");
            messageServiceClient = client;
            try {
                messageServiceClient.subscribe("icefacesPush", announcementMessageHandler.getMessageSelector());
            }
            catch (MessageServiceException exception) {
                if (LOG.isFatalEnabled()) {
                    LOG.fatal((Object)("\r\n\r\nFailed to subscribe to topic: icefacesPush\r\n    Exception message: " + exception.getMessage() + "\r\n" + "    Exception cause: " + exception.getCause() + "\r\n\r\n"));
                }
                blockingRequestHandlerContext = null;
                messageServiceClient = null;
                return;
            }
            messageServiceClient.addMessageHandler(announcementMessageHandler, "icefacesPush");
        }
    }

    public static synchronized void viewNumberDisposed(Object source, String iceFacesId, int viewNumber) {
        ViewNumberDisposedEvent viewNumberDisposedEvent = new ViewNumberDisposedEvent(source, iceFacesId, viewNumber);
        Iterator _listeners = listeners.keySet().iterator();
        while (_listeners.hasNext()) {
            ((ContextEventListener)_listeners.next()).viewNumberDisposed(viewNumberDisposedEvent);
        }
        ContextEventRepeater.removeBufferedEvents(iceFacesId, viewNumber);
        if (messageServiceClient != null) {
            com.icesoft.util.Properties _messageProperties = new com.icesoft.util.Properties();
            _messageProperties.setStringProperty("destination_servletContextPath", blockingRequestHandlerContext);
            messageServiceClient.publish(ContextEventRepeater.createMessage(viewNumberDisposedEvent), (Properties)_messageProperties, CONTEXT_EVENT_MESSAGE_TYPE, "icefacesPush");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("View Number disposed: " + viewNumberDisposedEvent.getViewNumber() + " " + "[ICEfaces ID: " + viewNumberDisposedEvent.getICEfacesID() + "]"));
        }
    }

    public static synchronized void viewNumberRetrieved(Object source, String iceFacesId, int viewNumber) {
        ViewNumberRetrievedEvent viewNumberRetrievedEvent = new ViewNumberRetrievedEvent(source, iceFacesId, viewNumber);
        bufferedContextEvents.add(viewNumberRetrievedEvent);
        Iterator _listeners = listeners.keySet().iterator();
        while (_listeners.hasNext()) {
            ((ContextEventListener)_listeners.next()).viewNumberRetrieved(viewNumberRetrievedEvent);
        }
        if (messageServiceClient != null) {
            com.icesoft.util.Properties _messageProperties = new com.icesoft.util.Properties();
            _messageProperties.setStringProperty("destination_servletContextPath", blockingRequestHandlerContext);
            messageServiceClient.publish(ContextEventRepeater.createMessage(viewNumberRetrievedEvent), (Properties)_messageProperties, CONTEXT_EVENT_MESSAGE_TYPE, "icefacesPush");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("View Number retrieved: " + viewNumberRetrievedEvent.getViewNumber() + " " + "[ICEfaces ID: " + viewNumberRetrievedEvent.getICEfacesID() + "]"));
        }
    }

    ContextEvent[] getBufferedContextEvents() {
        return bufferedContextEvents.toArray(new ContextEvent[bufferedContextEvents.size()]);
    }

    private static String createMessage(ContextEvent event) {
        if (event instanceof ICEfacesIDDisposedEvent) {
            return "ICEfacesIDDisposed;" + ((ICEfacesIDDisposedEvent)event).getICEfacesID();
        }
        if (event instanceof ICEfacesIDRetrievedEvent) {
            return "ICEfacesIDRetrieved;" + ((ICEfacesIDRetrievedEvent)event).getICEfacesID();
        }
        if (event instanceof ViewNumberDisposedEvent) {
            return "ViewNumberDisposed;" + ((ViewNumberDisposedEvent)event).getICEfacesID() + ";" + ((ViewNumberDisposedEvent)event).getViewNumber();
        }
        if (event instanceof ViewNumberRetrievedEvent) {
            return "ViewNumberRetrieved;" + ((ViewNumberRetrievedEvent)event).getICEfacesID() + ";" + ((ViewNumberRetrievedEvent)event).getViewNumber();
        }
        return null;
    }

    private static synchronized void removeBufferedEvents(String iceFacesId) {
        Iterator it = bufferedContextEvents.iterator();
        while (it.hasNext()) {
            Object event = it.next();
            if ((!(event instanceof ICEfacesIDRetrievedEvent) || !((ICEfacesIDRetrievedEvent)event).getICEfacesID().equals(iceFacesId)) && (!(event instanceof ViewNumberRetrievedEvent) || !((ViewNumberRetrievedEvent)event).getICEfacesID().equals(iceFacesId))) continue;
            it.remove();
        }
    }

    private static synchronized void removeBufferedEvents(String iceFacesId, int viewNumber) {
        Iterator it = bufferedContextEvents.iterator();
        while (it.hasNext()) {
            Object event = it.next();
            if (!(event instanceof ViewNumberRetrievedEvent) || !((ViewNumberRetrievedEvent)event).getICEfacesID().equals(iceFacesId) || ((ViewNumberRetrievedEvent)event).getViewNumber() != viewNumber) continue;
            it.remove();
        }
    }

    private static synchronized void sendBufferedEvents(ContextEventListener contextEventListener) {
        Iterator it = bufferedContextEvents.iterator();
        while (it.hasNext()) {
            Object event = it.next();
            if (event instanceof ICEfacesIDRetrievedEvent) {
                contextEventListener.iceFacesIdRetrieved((ICEfacesIDRetrievedEvent)event);
                continue;
            }
            if (!(event instanceof ViewNumberRetrievedEvent)) continue;
            contextEventListener.viewNumberRetrieved((ViewNumberRetrievedEvent)event);
        }
    }

    static {
        announcementMessageHandler = new AnnouncementMessageHandler(){

            public void publishBufferedContextEvents() {
                ContextEvent[] _contextEvents = bufferedContextEvents.toArray(new ContextEvent[bufferedContextEvents.size()]);
                if (_contextEvents.length != 0) {
                    StringBuffer _message = new StringBuffer();
                    for (int i = 0; i < _contextEvents.length; ++i) {
                        if (i != 0) {
                            _message.append("\r\n");
                        }
                        _message.append(ContextEventRepeater.createMessage(_contextEvents[i]));
                    }
                    com.icesoft.util.Properties _messageProperties = new com.icesoft.util.Properties();
                    _messageProperties.setStringProperty("destination_servletContextPath", blockingRequestHandlerContext);
                    messageServiceClient.publish(_message.toString(), (Properties)_messageProperties, ContextEventRepeater.BUFFERED_CONTEXT_EVENTS_MESSAGE_TYPE, "icefacesPush");
                }
            }
        };
    }
}

