/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.xml.FlatDtdDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.dataset.xml.FlatXmlProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public final class FlatXmlDataSetBuilder {
    private static final Logger logger = LoggerFactory.getLogger((Class)FlatXmlDataSetBuilder.class);
    private IDataSet metaDataSet = null;
    private boolean dtdMetadata = true;
    private boolean columnSensing = false;
    private boolean caseSensitiveTableNames = false;

    public FlatXmlDataSet build(InputSource inputSource) throws DataSetException {
        return this.buildInternal(inputSource);
    }

    public FlatXmlDataSet build(File xmlInputFile) throws MalformedURLException, DataSetException {
        URL xmlInputUrl = xmlInputFile.toURL();
        InputSource inputSource = this.createInputSourceFromUrl(xmlInputUrl);
        return this.buildInternal(inputSource);
    }

    public FlatXmlDataSet build(URL xmlInputUrl) throws DataSetException {
        InputSource inputSource = this.createInputSourceFromUrl(xmlInputUrl);
        return this.buildInternal(inputSource);
    }

    public FlatXmlDataSet build(Reader xmlReader) throws DataSetException {
        InputSource inputSource = new InputSource(xmlReader);
        return this.buildInternal(inputSource);
    }

    public FlatXmlDataSet build(InputStream xmlInputStream) throws DataSetException {
        InputSource inputSource = new InputSource(xmlInputStream);
        return this.buildInternal(inputSource);
    }

    private InputSource createInputSourceFromUrl(URL xmlInputUrl) {
        String stringUrl = xmlInputUrl.toString();
        return new InputSource(stringUrl);
    }

    public FlatXmlDataSetBuilder setMetaDataSet(IDataSet metaDataSet) {
        this.metaDataSet = metaDataSet;
        return this;
    }

    public FlatXmlDataSetBuilder setMetaDataSetFromDtd(Reader dtdReader) throws DataSetException, IOException {
        this.metaDataSet = new FlatDtdDataSet(dtdReader);
        return this;
    }

    public FlatXmlDataSetBuilder setMetaDataSetFromDtd(InputStream dtdStream) throws DataSetException, IOException {
        this.metaDataSet = new FlatDtdDataSet(dtdStream);
        return this;
    }

    public boolean isDtdMetadata() {
        return this.dtdMetadata;
    }

    public FlatXmlDataSetBuilder setDtdMetadata(boolean dtdMetadata) {
        this.dtdMetadata = dtdMetadata;
        return this;
    }

    public boolean isColumnSensing() {
        return this.columnSensing;
    }

    public FlatXmlDataSetBuilder setColumnSensing(boolean columnSensing) {
        this.columnSensing = columnSensing;
        return this;
    }

    public boolean isCaseSensitiveTableNames() {
        return this.caseSensitiveTableNames;
    }

    public FlatXmlDataSetBuilder setCaseSensitiveTableNames(boolean caseSensitiveTableNames) {
        this.caseSensitiveTableNames = caseSensitiveTableNames;
        return this;
    }

    private FlatXmlDataSet buildInternal(InputSource inputSource) throws DataSetException {
        logger.trace("build(inputSource={}) - start", (Object)inputSource);
        if (inputSource == null) {
            throw new NullPointerException("The parameter 'inputSource' must not be null");
        }
        logger.debug("Creating FlatXmlDataSet with builder parameters: {}", (Object)this);
        FlatXmlProducer producer = this.createProducer(inputSource);
        return new FlatXmlDataSet(producer);
    }

    protected FlatXmlProducer createProducer(InputSource inputSource) {
        logger.trace("createProducer(inputSource={}) - start", (Object)inputSource);
        FlatXmlProducer producer = null;
        if (this.metaDataSet != null) {
            logger.debug("Creating FlatXmlProducer using the following metaDataSet: {}", (Object)this.metaDataSet);
            producer = new FlatXmlProducer(inputSource, this.metaDataSet);
        } else {
            logger.debug("Creating FlatXmlProducer using the properties of this builder: {}", (Object)this);
            producer = new FlatXmlProducer(inputSource, this.dtdMetadata, this.columnSensing, this.caseSensitiveTableNames);
        }
        return producer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append("[");
        sb.append("dtdMetadata=").append(this.dtdMetadata);
        sb.append(", columnSensing=").append(this.columnSensing);
        sb.append(", caseSensitiveTableNames=").append(this.caseSensitiveTableNames);
        sb.append(", metaDataSet=").append(this.metaDataSet);
        sb.append("]");
        return sb.toString();
    }
}

