/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty.internal;

import java.io.File;
import java.util.HashMap;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.spi.configuration.AbstractStandaloneLocalConfiguration;
import org.codehaus.cargo.container.spi.deployer.AbstractCopyingInstalledLocalDeployer;

public abstract class AbstractJettyStandaloneLocalConfiguration
extends AbstractStandaloneLocalConfiguration {
    public AbstractJettyStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.rmi.port", "8079");
        this.setProperty("cargo.jetty.servlet.default.useFileMappedBuffer", "true");
        this.setProperty("cargo.jetty.createContextXml", "true");
    }

    protected FilterChain createJettyFilterChain() {
        FilterChain filterChain = this.createFilterChain();
        return filterChain;
    }

    protected abstract AbstractCopyingInstalledLocalDeployer createDeployer(InstalledLocalContainer var1);

    protected void doConfigure(LocalContainer container) throws Exception {
        InstalledLocalContainer ilContainer = (InstalledLocalContainer)container;
        this.setupConfigurationDir();
        FilterChain filterChain = this.createJettyFilterChain();
        String etcDir = this.getFileHandler().createDirectory(this.getHome(), "etc");
        this.getFileHandler().copyDirectory(this.getFileHandler().append(ilContainer.getHome(), "etc"), etcDir);
        HashMap<String, String> replaceJettyHome = new HashMap<String, String>(1);
        replaceJettyHome.put("jetty.home", "config.home");
        for (String etcChild : this.getFileHandler().getChildren(etcDir)) {
            this.getFileHandler().replaceInFile(etcChild, replaceJettyHome, "UTF-8", true);
        }
        this.getResourceUtils().copyResource("org/codehaus/cargo/container/internal/resources/" + container.getId() + "/webdefault.xml", new File(etcDir, "webdefault.xml"), filterChain, "UTF-8");
        String appDir = this.getFileHandler().createDirectory(this.getHome(), "webapps");
        this.getFileHandler().createDirectory(this.getHome(), "logs");
        this.getFileHandler().createDirectory(this.getHome(), "contexts");
        AbstractCopyingInstalledLocalDeployer deployer = this.createDeployer(ilContainer);
        deployer.deploy(this.getDeployables());
        this.getResourceUtils().copyResource("org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(appDir, "cargocpc.war"));
    }
}

