/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty.internal;

import java.io.File;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.jetty.internal.JettyExistingLocalConfigurationCapability;
import org.codehaus.cargo.container.spi.configuration.AbstractExistingLocalConfiguration;
import org.codehaus.cargo.container.spi.deployer.AbstractInstalledLocalDeployer;

public abstract class AbstractJettyExistingLocalConfiguration
extends AbstractExistingLocalConfiguration {
    private static ConfigurationCapability capability = new JettyExistingLocalConfigurationCapability();

    public AbstractJettyExistingLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.rmi.port", "8079");
        this.setProperty("cargo.jetty.createContextXml", "true");
    }

    public abstract AbstractInstalledLocalDeployer createDeployer(LocalContainer var1);

    protected void doConfigure(LocalContainer container) throws Exception {
        File deployDir = new File(this.getHome(), "webapps");
        if (!deployDir.exists()) {
            throw new ContainerException("Invalid existing configuration: The [" + deployDir.getPath() + "] directory does not exist");
        }
        AbstractInstalledLocalDeployer deployer = this.createDeployer(container);
        deployer.deploy(this.getDeployables());
        this.getResourceUtils().copyResource("org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(deployDir, "cargocpc.war"));
    }

    public ConfigurationCapability getCapability() {
        return capability;
    }

    public String toString() {
        return "Jetty Existing Configuration";
    }
}

