/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty.internal;

import java.io.File;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.spi.configuration.AbstractStandaloneLocalConfiguration;

public abstract class AbstractJettyEmbeddedStandaloneLocalConfiguration
extends AbstractStandaloneLocalConfiguration {
    public AbstractJettyEmbeddedStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.jetty.servlet.default.useFileMappedBuffer", "true");
        this.setProperty("cargo.jetty.createContextXml", "true");
    }

    public abstract ConfigurationCapability getCapability();

    protected FilterChain createJettyFilterChain() {
        FilterChain filterChain = this.createFilterChain();
        return filterChain;
    }

    public void doConfigure(LocalContainer container) throws Exception {
        try {
            this.setupConfigurationDir();
            FilterChain filterChain = this.createJettyFilterChain();
            String etcDir = this.getFileHandler().createDirectory(this.getHome(), "etc");
            this.getResourceUtils().copyResource("org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(this.getHome(), "cargocpc.war"));
            this.getResourceUtils().copyResource("org/codehaus/cargo/container/internal/resources/" + container.getId() + "/webdefault.xml", new File(etcDir, "webdefault.xml"), filterChain, "UTF-8");
            if (container.getOutput() != null) {
                this.activateLogging(container);
            }
        }
        catch (Exception e) {
            throw new ContainerException("Failed to create a " + container.getName() + " container configuration", (Throwable)e);
        }
    }

    protected abstract void activateLogging(LocalContainer var1) throws Exception;
}

