/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import java.util.HashMap;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.jetty.Jetty8xStandaloneLocalConfiguration;
import org.codehaus.cargo.container.jetty.Jetty9xInstalledLocalDeployer;
import org.codehaus.cargo.container.spi.deployer.AbstractCopyingInstalledLocalDeployer;

public class Jetty9xStandaloneLocalConfiguration
extends Jetty8xStandaloneLocalConfiguration {
    public Jetty9xStandaloneLocalConfiguration(String dir) {
        super(dir);
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        super.doConfigure(container);
        InstalledLocalContainer installedContainer = (InstalledLocalContainer)container;
        this.getFileHandler().copyDirectory(installedContainer.getHome() + "/start.d", this.getHome() + "/start.d");
        String httpIni = this.getFileHandler().append(this.getHome(), "start.d/http.ini");
        if (this.getFileHandler().exists(httpIni)) {
            HashMap<String, String> httpIniReplacements = new HashMap<String, String>(1);
            httpIniReplacements.put("8080", this.getPropertyValue("cargo.servlet.port"));
            this.getFileHandler().replaceInFile(httpIni, httpIniReplacements, "UTF-8", false);
        }
        String libExt = this.getHome() + "/lib/ext";
        for (String extraClasspath : installedContainer.getExtraClasspath()) {
            String destinationFile = libExt + "/" + this.getFileHandler().getName(extraClasspath);
            this.getFileHandler().copyFile(extraClasspath, destinationFile);
        }
    }

    protected AbstractCopyingInstalledLocalDeployer createDeployer(InstalledLocalContainer container) {
        Jetty9xInstalledLocalDeployer deployer = new Jetty9xInstalledLocalDeployer(container);
        return deployer;
    }

    public String toString() {
        return "Jetty 9.x Standalone Configuration";
    }
}

