/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.configuration.entry.DataSource;
import org.codehaus.cargo.container.jetty.Jetty7xInstalledLocalDeployer;
import org.codehaus.cargo.container.jetty.internal.AbstractJettyStandaloneLocalConfiguration;
import org.codehaus.cargo.container.jetty.internal.Jetty7xStandaloneLocalConfigurationCapability;
import org.codehaus.cargo.container.spi.deployer.AbstractCopyingInstalledLocalDeployer;

public class Jetty7xStandaloneLocalConfiguration
extends AbstractJettyStandaloneLocalConfiguration {
    private static ConfigurationCapability capability = new Jetty7xStandaloneLocalConfigurationCapability();

    public Jetty7xStandaloneLocalConfiguration(String dir) {
        super(dir);
    }

    public ConfigurationCapability getCapability() {
        return capability;
    }

    protected FilterChain createJettyFilterChain() {
        FilterChain filterChain = super.createJettyFilterChain();
        String sessionPath = this.getPropertyValue("cargo.jetty.session.path");
        String sessionContextParam = "";
        if (sessionPath != null) {
            sessionContextParam = "  <context-param>\n    <param-name>org.eclipse.jetty.servlet.SessionPath</param-name>\n    <param-value>" + sessionPath + "</param-value>\n" + "  </context-param>\n";
        }
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.jetty.session.path.context-param", sessionContextParam);
        return filterChain;
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        super.doConfigure(container);
        String etcDir = this.getFileHandler().append(this.getHome(), "etc");
        HashMap<String, String> jettyXmlReplacements = new HashMap<String, String>();
        jettyXmlReplacements.put("<Property", "<SystemProperty");
        if (this.getDataSources() != null && !this.getDataSources().isEmpty()) {
            this.configureDatasource(container, etcDir);
        }
        this.getFileHandler().replaceInFile(this.getFileHandler().append(etcDir, "jetty.xml"), jettyXmlReplacements, "UTF-8");
    }

    protected AbstractCopyingInstalledLocalDeployer createDeployer(InstalledLocalContainer container) {
        Jetty7xInstalledLocalDeployer deployer = new Jetty7xInstalledLocalDeployer(container);
        return deployer;
    }

    protected void configureDatasource(LocalContainer container, String etcDir) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("<Call name=\"setAttribute\">\n");
        sb.append("  <Arg>org.eclipse.jetty.webapp.configuration</Arg>\n");
        sb.append("  <Arg>\n");
        sb.append("    <Array type=\"java.lang.String\">\n");
        sb.append("      <Item>org.eclipse.jetty.webapp.WebInfConfiguration</Item>\n");
        sb.append("      <Item>org.eclipse.jetty.webapp.WebXmlConfiguration</Item>\n");
        sb.append("      <Item>org.eclipse.jetty.webapp.MetaInfConfiguration</Item>\n");
        sb.append("      <Item>org.eclipse.jetty.webapp.FragmentConfiguration</Item>\n");
        sb.append("      <Item>org.eclipse.jetty.plus.webapp.EnvConfiguration</Item>\n");
        sb.append("      <Item>org.eclipse.jetty.plus.webapp.PlusConfiguration</Item>\n");
        sb.append("      <Item>org.eclipse.jetty.webapp.JettyWebXmlConfiguration</Item>\n");
        sb.append("      <Item>org.eclipse.jetty.webapp.TagLibConfiguration</Item>\n");
        sb.append("    </Array>\n");
        sb.append("  </Arg>\n");
        sb.append("</Call>\n");
        this.createDatasourceDefinitions(sb, container);
        HashMap<String, String> jettyXmlReplacements = new HashMap<String, String>();
        jettyXmlReplacements.put("</Configure>", sb.toString() + "</Configure>");
        this.getFileHandler().replaceInFile(this.getFileHandler().append(etcDir, "jetty.xml"), jettyXmlReplacements, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDatasourceDefinitions(StringBuilder sb, LocalContainer container) throws IOException {
        for (DataSource ds : this.getDataSources()) {
            sb.append("\n");
            sb.append("<New id=\"" + ds.getId() + "\" class=\"org.eclipse.jetty.plus.jndi.Resource\">\n");
            sb.append("  <Arg>" + ds.getJndiLocation() + "</Arg>\n");
            sb.append("  <Arg>\n");
            sb.append("    <New class=\"com.mchange.v2.c3p0.ComboPooledDataSource\">\n");
            sb.append("      <Set name=\"driverClass\">" + ds.getDriverClass() + "</Set>\n");
            sb.append("      <Set name=\"jdbcUrl\">" + ds.getUrl() + "</Set>\n");
            sb.append("      <Set name=\"user\">" + ds.getUsername() + "</Set>\n");
            sb.append("      <Set name=\"password\">" + ds.getPassword() + "</Set>\n");
            sb.append("    </New>\n");
            sb.append("  </Arg>\n");
            sb.append("</New>\n");
        }
        InputStream c3p0Reader = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/codehaus/cargo/container/jetty/datasource/c3p0.jar");
        String c3p0File = this.getFileHandler().append(this.getHome(), "lib/ext/c3p0.jar");
        OutputStream c3p0Writer = this.getFileHandler().getOutputStream(c3p0File);
        try {
            this.getFileHandler().copy(c3p0Reader, c3p0Writer);
        }
        finally {
            c3p0Writer.close();
            c3p0Writer = null;
            System.gc();
        }
        InstalledLocalContainer installedContainer = (InstalledLocalContainer)container;
        installedContainer.addExtraClasspath(c3p0File);
    }

    public String toString() {
        return "Jetty 7.x Standalone Configuration";
    }
}

