/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import java.io.File;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.jetty.Jetty6xInstalledLocalContainer;
import org.codehaus.cargo.container.property.LoggingLevel;
import org.codehaus.cargo.container.spi.jvm.JvmLauncher;

public class Jetty7xInstalledLocalContainer
extends Jetty6xInstalledLocalContainer {
    public static final String ID = "jetty7x";
    protected String defaultFinalOptions = "jmx,resources,websocket,ext,plus";
    private String options;

    public Jetty7xInstalledLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    public String getId() {
        return ID;
    }

    protected void invoke(JvmLauncher java, boolean isGettingStarted) throws Exception {
        if ((this.getConfiguration().getPropertyValue("cargo.runtime.args") == null || !this.getConfiguration().getPropertyValue("cargo.runtime.args").contains("--ini=")) && LoggingLevel.HIGH.equalsLevel(this.getConfiguration().getPropertyValue("cargo.logging"))) {
            java.setSystemProperty("org.eclipse.jetty.DEBUG", "true");
        }
        super.invoke(java, isGettingStarted);
    }

    protected String[] getStartArguments(String classpath) {
        return new String[]{this.getOptions(), "--ini", "--pre=" + this.getFileHandler().append(this.getConfiguration().getHome(), "etc/jetty-logging.xml"), "--pre=" + this.getFileHandler().append(this.getConfiguration().getHome(), "etc/jetty.xml"), "--pre=" + this.getFileHandler().append(this.getConfiguration().getHome(), "etc/jetty-deploy.xml"), "--pre=" + this.getFileHandler().append(this.getConfiguration().getHome(), "etc/jetty-webapps.xml"), "--pre=" + this.getFileHandler().append(this.getConfiguration().getHome(), "etc/jetty-contexts.xml"), "--pre=" + this.getFileHandler().append(this.getConfiguration().getHome(), "etc/jetty-testrealm.xml"), "path=" + classpath};
    }

    protected synchronized String getOptions() {
        if (this.options == null) {
            StringBuilder options = new StringBuilder("OPTIONS=Server");
            File jspLib = new File(this.getHome(), "lib/jsp");
            if (jspLib.isDirectory()) {
                options.append(",jsp");
            } else {
                this.getLogger().warn("JSP librairies not found in " + jspLib + ", JSP support will be disabled", ((Object)((Object)this)).getClass().getName());
            }
            options.append("," + this.defaultFinalOptions);
            this.options = options.toString();
        }
        return this.options;
    }
}

