/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.jetty.Jetty6xEmbeddedLocalContainer;
import org.codehaus.cargo.container.property.User;

public class Jetty7xEmbeddedLocalContainer
extends Jetty6xEmbeddedLocalContainer {
    public static final String ID = "jetty7x";

    public Jetty7xEmbeddedLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    public String getId() {
        return ID;
    }

    public void setDefaultRealm(Object webapp) throws Exception {
        Class<?> userRealmClass = this.getClassLoader().loadClass("org.eclipse.jetty.security.LoginService");
        if (this.defaultRealm != null) {
            Object securityHandler = webapp.getClass().getMethod("getSecurityHandler", new Class[0]).invoke(webapp, new Object[0]);
            securityHandler.getClass().getMethod("setLoginService", userRealmClass).invoke(securityHandler, this.defaultRealm);
        }
    }

    protected void configureJettyConnectors() throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> selectConnectorClass = this.getClassLoader().loadClass("org.eclipse.jetty.server.nio.SelectChannelConnector");
        Object connector = selectConnectorClass.newInstance();
        selectConnectorClass.getMethod("setPort", Integer.TYPE).invoke(connector, new Integer(this.getConfiguration().getPropertyValue("cargo.servlet.port")));
        Class<?> connectorClass = this.getClassLoader().loadClass("org.eclipse.jetty.server.Connector");
        Object connectorArray = Array.newInstance(connectorClass, 1);
        Array.set(connectorArray, 0, connector);
        this.getServer().getClass().getMethod("addConnector", connectorClass).invoke(this.getServer(), connector);
    }

    protected void addJettyHandlers() throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        this.handlerClass = this.getClassLoader().loadClass("org.eclipse.jetty.server.Handler");
        this.handlers = this.getClassLoader().loadClass("org.eclipse.jetty.server.handler.HandlerCollection").newInstance();
        this.contextHandlers = this.getClassLoader().loadClass("org.eclipse.jetty.server.handler.ContextHandlerCollection").newInstance();
        Object defaultHandler = this.getClassLoader().loadClass("org.eclipse.jetty.server.handler.DefaultHandler").newInstance();
        Object handlerArray = Array.newInstance(this.handlerClass, 2);
        Array.set(handlerArray, 0, this.contextHandlers);
        Array.set(handlerArray, 1, defaultHandler);
        this.handlers.getClass().getMethod("setHandlers", handlerArray.getClass()).invoke(this.handlers, handlerArray);
        this.getServer().getClass().getMethod("setHandler", this.handlerClass).invoke(this.getServer(), this.handlers);
        this.addHandlerMethod = this.contextHandlers.getClass().getMethod("addHandler", this.handlerClass);
        this.removeHandlerMethod = this.contextHandlers.getClass().getMethod("removeHandler", this.handlerClass);
    }

    public Object createHandler(Deployable deployable) throws Exception {
        Object handler = this.getClassLoader().loadClass("org.eclipse.jetty.webapp.WebAppContext").newInstance();
        handler.getClass().getMethod("setContextPath", String.class).invoke(handler, "/" + ((WAR)deployable).getContext());
        handler.getClass().getMethod("setWar", String.class).invoke(handler, deployable.getFile());
        handler.getClass().getMethod("setDefaultsDescriptor", String.class).invoke(handler, this.getFileHandler().append(this.getConfiguration().getHome(), "etc/webdefault.xml"));
        this.setDefaultRealm(handler);
        return handler;
    }

    public Object createHandler(String contextPath, String war) throws Exception {
        Object handler = this.getClassLoader().loadClass("org.eclipse.jetty.webapp.WebAppContext").newInstance();
        handler.getClass().getMethod("setContextPath", String.class).invoke(handler, contextPath);
        handler.getClass().getMethod("setWar", String.class).invoke(handler, war);
        this.setDefaultRealm(handler);
        return handler;
    }

    protected void setSecurityRealm() throws Exception {
        if (this.getConfiguration().getPropertyValue("cargo.servlet.users") != null) {
            Class<?> realmClass = this.getClassLoader().loadClass("org.eclipse.jetty.security.HashLoginService");
            this.defaultRealm = realmClass.getConstructor(String.class).newInstance("Cargo Test Realm");
            for (User user : User.parseUsers((String)this.getConfiguration().getPropertyValue("cargo.servlet.users"))) {
                Class<?> credentialClass;
                String userName = user.getName();
                try {
                    credentialClass = this.getClassLoader().loadClass("org.eclipse.jetty.http.security.Credential");
                }
                catch (ClassNotFoundException e) {
                    credentialClass = this.getClassLoader().loadClass("org.eclipse.jetty.util.security.Credential");
                }
                Object credential = credentialClass.getMethod("getCredential", String.class).invoke(credentialClass, user.getPassword());
                String[] roles = user.getRoles().toArray(new String[user.getRoles().size()]);
                Method putUser = this.defaultRealm.getClass().getMethod("putUser", String.class, credentialClass, String[].class);
                putUser.invoke(this.defaultRealm, userName, credential, roles);
            }
            Object userRealmsArray = Array.newInstance(this.getClassLoader().loadClass("org.eclipse.jetty.security.LoginService"), 1);
            Array.set(userRealmsArray, 0, this.defaultRealm);
        }
    }

    protected synchronized void createServerObject() throws Exception {
        if (this.server == null) {
            try {
                this.server = this.getClassLoader().loadClass("org.eclipse.jetty.server.Server").newInstance();
            }
            catch (Exception e) {
                throw new ContainerException("Failed to create Jetty Server instance", (Throwable)e);
            }
            this.server.getClass().getMethod("setStopAtShutdown", Boolean.TYPE).invoke(this.server, Boolean.TRUE);
        }
    }
}

