/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.jetty.Jetty6xInstalledLocalDeployer;
import org.codehaus.cargo.container.jetty.internal.AbstractJettyStandaloneLocalConfiguration;
import org.codehaus.cargo.container.jetty.internal.JettyStandaloneLocalConfigurationCapability;
import org.codehaus.cargo.container.spi.deployer.AbstractCopyingInstalledLocalDeployer;

public class Jetty6xStandaloneLocalConfiguration
extends AbstractJettyStandaloneLocalConfiguration {
    private static ConfigurationCapability capability = new JettyStandaloneLocalConfigurationCapability();

    public Jetty6xStandaloneLocalConfiguration(String dir) {
        super(dir);
    }

    public ConfigurationCapability getCapability() {
        return capability;
    }

    protected FilterChain createJettyFilterChain() {
        FilterChain filterChain = super.createJettyFilterChain();
        String sessionPath = this.getPropertyValue("cargo.jetty.session.path");
        String sessionContextParam = "";
        if (sessionPath != null) {
            sessionContextParam = "  <context-param>\n    <param-name>org.mortbay.jetty.servlet.SessionPath</param-name>\n    <param-value>" + sessionPath + "</param-value>\n" + "  </context-param>\n";
        }
        this.getAntUtils().addTokenToFilterChain(filterChain, "cargo.jetty.session.path.context-param", sessionContextParam);
        return filterChain;
    }

    protected AbstractCopyingInstalledLocalDeployer createDeployer(InstalledLocalContainer container) {
        Jetty6xInstalledLocalDeployer deployer = new Jetty6xInstalledLocalDeployer(container);
        return deployer;
    }

    public String toString() {
        return "Jetty 6.x Standalone Configuration";
    }
}

