/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import java.io.IOException;
import java.io.OutputStream;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.spi.deployer.AbstractCopyingInstalledLocalDeployer;

public class Jetty6xInstalledLocalDeployer
extends AbstractCopyingInstalledLocalDeployer {
    public Jetty6xInstalledLocalDeployer(InstalledLocalContainer container) {
        super(container);
    }

    public String getDeployableDir() {
        return this.getFileHandler().append(this.getContainer().getConfiguration().getHome(), "webapps");
    }

    public String getContextsDir() {
        return this.getFileHandler().append(this.getContainer().getConfiguration().getHome(), "contexts");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDeploy(String deployableDir, Deployable deployable) {
        String createContextXml = this.getContainer().getConfiguration().getPropertyValue("cargo.jetty.createContextXml");
        if (DeployableType.WAR.equals((Object)deployable.getType()) && Boolean.valueOf(createContextXml).booleanValue()) {
            WAR war = (WAR)deployable;
            String contextDir = this.getContextsDir();
            String contextFile = war.getContext();
            if ("/".equals(contextFile) || "".equals(contextFile)) {
                contextFile = "root";
            }
            contextFile = contextFile.replace('/', '-');
            contextFile = this.getFileHandler().append(contextDir, contextFile + ".xml");
            this.getFileHandler().createFile(contextFile);
            this.getLogger().info("Deploying WAR by creating Jetty context XML file in [" + contextFile + "]...", ((Object)((Object)this)).getClass().getName());
            OutputStream out = this.getFileHandler().getOutputStream(contextFile);
            try {
                out.write(this.createContextXml(war).getBytes("UTF-8"));
                out.close();
            }
            catch (IOException e) {
                throw new ContainerException("Failed to create Jetty Context file for [" + war.getFile() + "]", (Throwable)e);
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException ignored) {
                }
                finally {
                    out = null;
                    System.gc();
                }
            }
        }
        super.doDeploy(deployableDir, deployable);
    }

    protected String createContextXml(WAR war) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        buffer.append("<!DOCTYPE Configure PUBLIC \"-//Mort Bay Consulting//DTD Configure//EN\" \"http://jetty.mortbay.org/configure.dtd\">\n");
        buffer.append("<Configure class=\"org.mortbay.jetty.webapp.WebAppContext\">\n");
        buffer.append("  <Array id=\"plusConfig\" type=\"java.lang.String\">\n");
        buffer.append("    <Item>org.mortbay.jetty.webapp.WebInfConfiguration</Item>\n");
        buffer.append("    <Item>org.mortbay.jetty.plus.webapp.EnvConfiguration</Item>\n");
        buffer.append("    <Item>org.mortbay.jetty.plus.webapp.Configuration</Item>\n");
        buffer.append("    <Item>org.mortbay.jetty.webapp.JettyWebXmlConfiguration</Item>\n");
        buffer.append("    <Item>org.mortbay.jetty.webapp.TagLibConfiguration</Item>\n");
        buffer.append("  </Array>\n");
        buffer.append("  <Set name=\"contextPath\">/" + war.getContext() + "</Set>\n");
        buffer.append("  <Set name=\"war\">" + war.getFile() + "</Set>\n");
        buffer.append("  <Set name=\"extractWAR\">true</Set>\n");
        buffer.append("  <Set name=\"defaultsDescriptor\"><SystemProperty name=\"config.home\" default=\".\"/>/etc/webdefault.xml</Set>\n");
        buffer.append("  <Set name=\"ConfigurationClasses\"><Ref id=\"plusConfig\"/></Set>\n");
        buffer.append(this.getSharedClasspathXmlFragment());
        buffer.append("</Configure>\n");
        return buffer.toString();
    }

    protected String getSharedClasspathXmlFragment() {
        InstalledLocalContainer installedLocalContainer;
        String[] sharedClasspath;
        StringBuilder buffer = new StringBuilder();
        if (this.getContainer() instanceof InstalledLocalContainer && (sharedClasspath = (installedLocalContainer = (InstalledLocalContainer)this.getContainer()).getSharedClasspath()) != null && sharedClasspath.length > 0) {
            buffer.append("  <Set name=\"extraClasspath\">\n");
            for (String sharedClasspathElement : sharedClasspath) {
                buffer.append("    " + sharedClasspathElement + ";\n");
            }
            buffer.append("  </Set>\n");
        }
        return buffer.toString();
    }
}

