/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.codehaus.cargo.container.ContainerCapability;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.internal.ServletContainerCapability;
import org.codehaus.cargo.container.property.LoggingLevel;
import org.codehaus.cargo.container.spi.AbstractInstalledLocalContainer;
import org.codehaus.cargo.container.spi.jvm.JvmLauncher;
import org.codehaus.cargo.util.CargoException;

public class Jetty6xInstalledLocalContainer
extends AbstractInstalledLocalContainer {
    public static final String ID = "jetty6x";
    private ContainerCapability capability = new ServletContainerCapability();
    private String version;

    public Jetty6xInstalledLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    public String getId() {
        return ID;
    }

    public String getName() {
        if (this.getHome() != null && this.getFileHandler().exists(this.getFileHandler().append(this.getHome(), "start.jar"))) {
            return "Jetty " + this.getVersion();
        }
        String className = ((Object)((Object)this)).getClass().getName();
        int jettyStart = className.lastIndexOf(".Jetty") + 6;
        String version = className.substring(jettyStart, className.indexOf(120, jettyStart));
        return "Jetty " + version + ".x";
    }

    protected synchronized String getVersion() {
        if (this.version == null) {
            try {
                JarFile startJar = new JarFile(new File(this.getHome(), "start.jar"));
                ZipEntry manifestFile = startJar.getEntry("META-INF/MANIFEST.MF");
                Properties manifest = new Properties();
                manifest.load(startJar.getInputStream(manifestFile));
                this.version = manifest.getProperty("Implementation-Version");
                if (this.version == null) {
                    this.version = manifest.getProperty("implementation-version");
                }
            }
            catch (IOException e) {
                throw new CargoException("Cannot open the start.jar file", (Throwable)e);
            }
            if (this.version == null) {
                throw new CargoException("The MANIFEST file of start.jar doesn't contain any Implementation Version");
            }
        }
        return this.version;
    }

    public void doStart(JvmLauncher java) throws Exception {
        this.invoke(java, true);
    }

    public void doStop(JvmLauncher java) throws Exception {
        this.invoke(java, false);
    }

    protected void invoke(JvmLauncher java, boolean isGettingStarted) throws Exception {
        if (this.getConfiguration().getPropertyValue("cargo.runtime.args") == null || !this.getConfiguration().getPropertyValue("cargo.runtime.args").contains("--ini=")) {
            if (LoggingLevel.HIGH.equalsLevel(this.getConfiguration().getPropertyValue("cargo.logging"))) {
                java.setSystemProperty("DEBUG", "true");
            }
            java.setSystemProperty("jetty.home", this.getHome());
            java.setSystemProperty("STOP.PORT", this.getConfiguration().getPropertyValue("cargo.rmi.port"));
            java.setSystemProperty("STOP.KEY", "secret");
            java.setSystemProperty("jetty.port", this.getConfiguration().getPropertyValue("cargo.servlet.port"));
            java.setSystemProperty("config.home", this.getConfiguration().getHome());
            java.setSystemProperty("jetty.logs", this.getFileHandler().append(this.getConfiguration().getHome(), "logs"));
        }
        java.setJarFile(new File(this.getHome(), "start.jar"));
        if (isGettingStarted) {
            if (this.getConfiguration().getPropertyValue("cargo.runtime.args") == null) {
                java.addAppArguments(this.getStartArguments(java.getClasspath()));
            }
            java.setSystemProperty("CLASSPATH", java.getClasspath());
        } else {
            java.addAppArguments(new String[]{"--stop"});
            java.addAppArguments(this.getStopArguments());
        }
        this.addToolsJarToClasspath(java);
        this.getLogger().debug("Running Jetty As: " + java.getCommandLine(), ((Object)((Object)this)).getClass().getName());
        if (isGettingStarted) {
            java.start();
        } else {
            int exitCode = java.execute();
            if (exitCode != 0 && exitCode != 252) {
                throw new CargoException("Jetty command failed: exit code was " + exitCode);
            }
        }
    }

    protected String[] getStartArguments(String classpath) {
        return new String[]{this.getFileHandler().append(this.getConfiguration().getHome(), "etc/jetty-logging.xml"), this.getFileHandler().append(this.getConfiguration().getHome(), "etc/jetty.xml")};
    }

    protected String[] getStopArguments() {
        return new String[0];
    }

    public ContainerCapability getCapability() {
        return this.capability;
    }
}

