/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import java.io.File;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.EmbeddedLocalContainer;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.jetty.Jetty5xEmbeddedLocalContainer;
import org.codehaus.cargo.container.jetty.internal.AbstractJettyEmbeddedLocalDeployer;

public class Jetty5xEmbeddedLocalDeployer
extends AbstractJettyEmbeddedLocalDeployer {
    public Jetty5xEmbeddedLocalDeployer(EmbeddedLocalContainer container) {
        super(container);
    }

    public Object deployWebApp(Deployable deployable) {
        this.getLogger().info("Deploying [" + deployable.getFile() + "]", ((Object)((Object)this)).getClass().getName());
        if (deployable.getType() == DeployableType.WAR) {
            try {
                Jetty5xEmbeddedLocalContainer container = (Jetty5xEmbeddedLocalContainer)this.getContainer();
                Object webapp = container.getServer().getClass().getMethod("addWebApplication", String.class, String.class).invoke(container.getServer(), Jetty5xEmbeddedLocalDeployer.getContext(deployable), deployable.getFile());
                webapp.getClass().getMethod("setDefaultsDescriptor", String.class).invoke(webapp, new File(container.getConfiguration().getHome(), "etc/webdefault.xml").toURI().toString());
                String[] virtualHosts = this.getVirtualHosts();
                for (int i = 0; virtualHosts != null && i < virtualHosts.length; ++i) {
                    webapp.getClass().getMethod("addVirtualHost", String.class).invoke(webapp, virtualHosts[i]);
                }
                if (this.getExtractWar() != null) {
                    webapp.getClass().getMethod("setExtractWAR", Boolean.TYPE).invoke(webapp, this.getExtractWar());
                }
                if (this.getParentLoaderPriority() != null) {
                    webapp.getClass().getMethod("setClassLoaderJava2Compliant", Boolean.TYPE).invoke(webapp, this.getParentLoaderPriority());
                }
                container.setDefaultRealm(webapp);
                webapp.getClass().getMethod("start", new Class[0]).invoke(webapp, new Object[0]);
                return webapp;
            }
            catch (Exception e) {
                throw new ContainerException("Failed to deploy [" + deployable.getFile() + "]", (Throwable)e);
            }
        }
        throw new ContainerException("Only WAR archives are supported for deployment in Jetty. Got [" + deployable.getFile() + "]");
    }

    public void undeployWebApp(Deployable deployable) {
        this.stop(deployable);
        try {
            Object webapp = Jetty5xEmbeddedLocalDeployer.getDeployedWebAppContext(deployable);
            webapp.getClass().getMethod("destroy", new Class[0]).invoke(webapp, new Object[0]);
        }
        catch (Exception e) {
            throw new ContainerException("Failed to undeploy [" + deployable.getFile() + "]", (Throwable)e);
        }
    }

    public void start(Deployable deployable) {
        try {
            Object webapp = Jetty5xEmbeddedLocalDeployer.getDeployedWebAppContext(deployable);
            webapp.getClass().getMethod("start", new Class[0]).invoke(webapp, new Object[0]);
        }
        catch (Exception e) {
            throw new ContainerException("Failed to start [" + deployable.getFile() + "]", (Throwable)e);
        }
    }

    public void stop(Deployable deployable) {
        try {
            Object webapp = Jetty5xEmbeddedLocalDeployer.getDeployedWebAppContext(deployable);
            webapp.getClass().getMethod("stop", new Class[0]).invoke(webapp, new Object[0]);
        }
        catch (Exception e) {
            throw new ContainerException("Failed to stop [" + deployable.getFile() + "]", (Throwable)e);
        }
    }
}

