/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.filters.util.ChainReaderHelper;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.util.FileUtils;
import org.codehaus.cargo.util.AntUtils;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.FileHandler;
import org.codehaus.cargo.util.XmlReplacement;
import org.codehaus.cargo.util.log.LoggedObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFileHandler
extends LoggedObject
implements FileHandler {
    private static int uniqueNameCounter = -1;
    private AntUtils antUtils = new AntUtils();
    private FileUtils fileUtils = FileUtils.newFileUtils();

    private AntUtils getAntUtils() {
        return this.antUtils;
    }

    private FileUtils getFileUtils() {
        return this.fileUtils;
    }

    @Override
    public void copyFile(String source, String target) {
        this.copyFile(source, target, false);
    }

    @Override
    public void copyFile(String source, String target, boolean overwrite) {
        try {
            this.getFileUtils().copyFile(new File(source).getAbsolutePath(), new File(target).getAbsolutePath(), null, overwrite);
        }
        catch (IOException e) {
            throw new CargoException("Failed to copy source file [" + source + "] to [" + target + "]", e);
        }
    }

    public void copyFile(String source, String target, FilterChain filterChain) {
        this.copyFile(source, target, filterChain, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyFile(String source, String target, FilterChain filterChain, String encoding) {
        try {
            FileInputStream fileIS = new FileInputStream(source);
            BufferedReader in = null;
            BufferedWriter out = null;
            try {
                String line;
                ChainReaderHelper helper = new ChainReaderHelper();
                helper.setBufferSize(8192);
                helper.setPrimaryReader((Reader)new BufferedReader(this.newReader(fileIS, encoding)));
                Vector<FilterChain> filterChains = new Vector<FilterChain>();
                filterChains.add(filterChain);
                helper.setFilterChains(filterChains);
                in = new BufferedReader(helper.getAssembledReader());
                out = new BufferedWriter(this.newWriter(target, encoding));
                while ((line = in.readLine()) != null) {
                    if (line.length() == 0) {
                        out.newLine();
                        continue;
                    }
                    out.write(line);
                    out.newLine();
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (IOException e) {
            throw new CargoException("Failed to copy source file [" + source + "] to [" + target + "] with FilterChain", e);
        }
    }

    @Override
    public void copyDirectory(String source, String target) {
        this.copyDirectory(source, target, new ArrayList<String>());
    }

    @Override
    public void copyDirectory(String source, String target, List<String> excludes) {
        try {
            Copy copyTask = (Copy)this.getAntUtils().createAntTask("copy");
            copyTask.setTodir(new File(target));
            FileSet fileSet = new FileSet();
            fileSet.setDir(new File(source));
            for (String excludeName : excludes) {
                fileSet.createExclude().setName(excludeName);
            }
            copyTask.addFileset(fileSet);
            copyTask.setFailOnError(true);
            copyTask.setIncludeEmptyDirs(true);
            copyTask.setOverwrite(true);
            copyTask.execute();
        }
        catch (BuildException e) {
            throw new CargoException("Failed to copy source directory [" + source + "] to [" + target + "]", e);
        }
    }

    @Override
    public void copyDirectory(String source, String target, FilterChain filterChain, String encoding) {
        File sourceDirectory = new File(source);
        if (!sourceDirectory.isDirectory()) {
            throw new CargoException("Source [" + source + "] is not a directory");
        }
        File targetDirectory = new File(target);
        if (!targetDirectory.isDirectory()) {
            targetDirectory.mkdirs();
        }
        if (!targetDirectory.isDirectory()) {
            throw new CargoException("Target directory [" + target + "] cannot be created");
        }
        for (File sourceDirectoryContent : sourceDirectory.listFiles()) {
            File targetFile = new File(targetDirectory, sourceDirectoryContent.getName());
            if (sourceDirectoryContent.isFile()) {
                this.copyFile(sourceDirectoryContent.getAbsolutePath(), targetFile.getAbsolutePath(), filterChain, encoding);
                continue;
            }
            this.copyDirectory(sourceDirectoryContent.getAbsolutePath(), targetFile.getAbsolutePath(), filterChain, encoding);
        }
    }

    @Override
    public String createDirectory(String parentDir, String name) {
        File dir = new File(parentDir, name);
        this.mkdirs(dir.getAbsolutePath());
        if (!dir.isDirectory() || !dir.exists()) {
            throw new CargoException("Couldn't create directory " + dir.getAbsolutePath());
        }
        return dir.getPath();
    }

    @Override
    public void copy(InputStream in, OutputStream out, int bufSize) {
        try {
            int length;
            byte[] buf = new byte[bufSize];
            while ((length = in.read(buf)) != -1) {
                out.write(buf, 0, length);
            }
        }
        catch (IOException e) {
            throw new CargoException("Failed to copy input stream [" + in.toString() + "] to output stream [" + out.toString() + "]", e);
        }
    }

    @Override
    public void copy(InputStream in, OutputStream out) {
        this.copy(in, out, 1024);
    }

    @Override
    public void replaceInFile(String file, Map<String, String> replacements, String encoding) throws CargoException {
        this.replaceInFile(file, replacements, encoding, false);
    }

    @Override
    public void replaceInFile(String file, Map<String, String> replacements, String encoding, boolean ignoreNonExistingProperties) throws CargoException {
        String fileContents = this.readTextFile(file, encoding);
        for (Map.Entry<String, String> replacement : replacements.entrySet()) {
            if (!fileContents.contains(replacement.getKey())) {
                String message = "File " + file + " does not contain replacement key " + replacement.getKey();
                if (ignoreNonExistingProperties) {
                    this.getLogger().debug(message, this.getClass().getName());
                    continue;
                }
                throw new CargoException(message);
            }
            fileContents = fileContents.replace(replacement.getKey(), replacement.getValue());
        }
        this.writeTextFile(file, fileContents, encoding);
    }

    @Override
    public void replaceInXmlFile(XmlReplacement ... xmlReplacements) throws CargoException {
        HashMap replacements = new HashMap();
        for (XmlReplacement xmlReplacement : xmlReplacements) {
            HashMap<FileHandler.XmlReplacementDetails, String> replacementDetails = (HashMap<FileHandler.XmlReplacementDetails, String>)replacements.get(xmlReplacement.getFile());
            if (replacementDetails == null) {
                replacementDetails = new HashMap<FileHandler.XmlReplacementDetails, String>();
                replacements.put(xmlReplacement.getFile(), replacementDetails);
            }
            FileHandler.XmlReplacementDetails xmlReplacementDetails = new FileHandler.XmlReplacementDetails(xmlReplacement.getXpathExpression(), xmlReplacement.getAttributeName(), xmlReplacement.isIgnoreIfNonExisting());
            replacementDetails.put(xmlReplacementDetails, xmlReplacement.getValue());
        }
        for (Map.Entry replacement : replacements.entrySet()) {
            this.replaceInXmlFile((String)replacement.getKey(), (Map)replacement.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceInXmlFile(String file, Map<FileHandler.XmlReplacementDetails, String> replacements) throws CargoException {
        InputStream is = null;
        OutputStream os = null;
        try {
            Document doc;
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            if (!this.exists(file)) {
                throw new CargoException("Cannot find file " + file);
            }
            if (this.isDirectory(file)) {
                throw new CargoException("The destination is a directory: " + file);
            }
            is = this.getInputStream(file);
            try {
                doc = builder.parse(is);
            }
            finally {
                is.close();
                is = null;
                System.gc();
            }
            for (Map.Entry<FileHandler.XmlReplacementDetails, String> replacement : replacements.entrySet()) {
                String expression = replacement.getKey().getXpathExpression();
                String attributeName = replacement.getKey().getAttributeName();
                XPathExpression xPathExpr = xPath.compile(expression);
                Node node = (Node)xPathExpr.evaluate(doc, XPathConstants.NODE);
                if (node == null) {
                    String message = "Node " + expression + " not found in file " + file;
                    if (replacement.getKey().isIgnoreIfNonExisting() == Boolean.TRUE) {
                        this.getLogger().debug(message, this.getClass().getName());
                        continue;
                    }
                    throw new CargoException(message);
                }
                if (attributeName != null) {
                    Node attribute = node.getAttributes().getNamedItem(attributeName);
                    if (attribute == null) {
                        ((Element)node).setAttribute(attributeName, replacement.getValue());
                        continue;
                    }
                    attribute.setNodeValue(replacement.getValue());
                    continue;
                }
                node.setTextContent(replacement.getValue());
            }
            this.delete(file);
            os = this.getOutputStream(file);
            transformer.transform(new DOMSource(doc), new StreamResult(os));
        }
        catch (Exception e) {
            throw new CargoException("Cannot modify XML file " + file, e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception ignored) {
                }
                finally {
                    is = null;
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception ignored) {
                }
                finally {
                    os = null;
                }
            }
            System.gc();
        }
    }

    @Override
    public String getTmpPath(String name) {
        return new File(new File(System.getProperty("java.io.tmpdir"), "cargo"), name).getPath();
    }

    @Override
    public synchronized String createUniqueTmpDirectory() {
        File tmpDir;
        if (uniqueNameCounter == -1) {
            uniqueNameCounter = new Random().nextInt() & 0xFFFF;
        }
        while ((tmpDir = new File(new File(System.getProperty("java.io.tmpdir")), "cargo/" + Integer.toString(++uniqueNameCounter))).exists()) {
        }
        tmpDir.deleteOnExit();
        this.mkdirs(tmpDir.getAbsolutePath());
        return tmpDir.getPath();
    }

    @Override
    public void delete(String path) {
        File pathAsFile = new File(path);
        if (pathAsFile.isDirectory()) {
            File[] children;
            for (File element : children = pathAsFile.listFiles()) {
                this.delete(element.getPath());
            }
        }
        pathAsFile.delete();
    }

    @Override
    public long getSize(String file) {
        File fileObject = new File(file).getAbsoluteFile();
        if (!fileObject.isFile()) {
            throw new CargoException("File [" + file + "] is not a file");
        }
        return fileObject.length();
    }

    @Override
    public InputStream getInputStream(String file) {
        FileInputStream is;
        try {
            is = new FileInputStream(new File(file).getAbsoluteFile());
        }
        catch (FileNotFoundException e) {
            throw new CargoException("Failed to find file [" + file + "]", e);
        }
        return is;
    }

    @Override
    public OutputStream getOutputStream(String file) {
        FileOutputStream os;
        String parent = this.getParent(file);
        if (parent != null) {
            this.mkdirs(parent);
        }
        try {
            os = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new CargoException("Failed to open output stream for file [" + file + "]", e);
        }
        return os;
    }

    @Override
    public String append(String path, String suffixToAppend) {
        String result = !path.endsWith("/") && !path.endsWith("\\") ? path + "/" + suffixToAppend : path + suffixToAppend;
        return result;
    }

    @Override
    public void mkdirs(String path) {
        File pathFile = new File(path);
        boolean success = false;
        for (int i = 0; i < 3 && !success; ++i) {
            success = pathFile.exists() ? true : pathFile.mkdirs();
        }
        if (!success) {
            throw new CargoException("Failed to create folders for path [" + path + "]");
        }
    }

    @Override
    public String getParent(String path) {
        return new File(path).getParent();
    }

    @Override
    public boolean exists(String path) {
        return new File(path).exists();
    }

    @Override
    public void createFile(String file) {
        try {
            new File(file).createNewFile();
        }
        catch (IOException e) {
            throw new CargoException("Failed to create file [" + file + "]", e);
        }
    }

    @Override
    public boolean isDirectoryEmpty(String dir) {
        return new File(dir).list().length == 0;
    }

    @Override
    public String getName(String file) {
        return new File(file).getName();
    }

    @Override
    public String getURL(String path) {
        URL result;
        try {
            result = new File(path).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new CargoException("Failed to return URL for [" + path + "]", e);
        }
        return result.toString();
    }

    @Override
    public boolean isDirectory(String path) {
        return new File(path).isDirectory();
    }

    @Override
    public String[] getChildren(String directory) {
        File[] files = new File(directory).listFiles();
        String[] results = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            results[i] = files[i].getPath();
        }
        return results;
    }

    @Override
    public String getAbsolutePath(String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("user.dir"), file.getPath());
        }
        return file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readTextFile(String file, String encoding) {
        String string;
        block8: {
            BufferedReader in = null;
            StringBuilder out = new StringBuilder();
            try {
                String str;
                in = new BufferedReader(this.newReader(this.getInputStream(file), encoding));
                while ((str = in.readLine()) != null) {
                    if (out.length() > 0) {
                        out.append(System.getProperty("line.separator"));
                    }
                    out.append(str);
                }
                string = out.toString();
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        in.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CargoException("Failed to read text from file: " + file, e);
                }
            }
            in.close();
        }
        return string;
    }

    @Override
    public void writeTextFile(String file, String content, String encoding) {
        Writer writer;
        try {
            writer = this.newWriter(file, encoding);
        }
        catch (IOException e) {
            throw new CargoException("Cannot get writer for file" + file, e);
        }
        try {
            writer.write(content);
        }
        catch (IOException e) {
            throw new CargoException("Cannot write file" + file, e);
        }
        finally {
            try {
                writer.close();
                writer = null;
                System.gc();
            }
            catch (IOException ignored) {}
        }
    }

    private Reader newReader(InputStream is, String encoding) throws IOException {
        if (encoding == null || encoding.length() <= 0) {
            return new InputStreamReader(is);
        }
        return new InputStreamReader(is, encoding);
    }

    private Writer newWriter(String file, String encoding) throws IOException {
        String parent = this.getParent(file);
        if (!this.isDirectory(parent)) {
            this.mkdirs(parent);
        }
        if (encoding == null || encoding.length() <= 0) {
            return new OutputStreamWriter(this.getOutputStream(file));
        }
        return new OutputStreamWriter(this.getOutputStream(file), encoding);
    }
}

