/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.configuration.entry.DataSource;
import org.codehaus.cargo.container.configuration.entry.Resource;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.internal.util.ResourceUtils;
import org.codehaus.cargo.container.property.DataSourceConverter;
import org.codehaus.cargo.container.property.ResourceConverter;
import org.codehaus.cargo.container.property.TransactionSupport;
import org.codehaus.cargo.container.spi.configuration.AbstractConfiguration;
import org.codehaus.cargo.util.AntUtils;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.FileHandler;
import org.codehaus.cargo.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLocalConfiguration
extends AbstractConfiguration
implements LocalConfiguration {
    protected static final String RESOURCE_PATH = "org/codehaus/cargo/container/internal/resources/";
    private List<Deployable> deployables = new ArrayList<Deployable>();
    private String home;
    private AntUtils antUtils;
    private ResourceUtils resourceUtils;
    private FileHandler fileHandler = new DefaultFileHandler();
    private List<Resource> resources;
    private List<DataSource> dataSources;

    public AbstractLocalConfiguration(String home) {
        this.antUtils = new AntUtils();
        this.resourceUtils = new ResourceUtils();
        this.resources = new ArrayList<Resource>();
        this.dataSources = new ArrayList<DataSource>();
        this.home = home;
        this.setProperty("cargo.java.home", System.getProperty("java.home"));
        this.setProperty("cargo.process.spawn", "false");
    }

    public void setLogger(Logger logger) {
        super.setLogger(logger);
        this.fileHandler.setLogger(logger);
    }

    @Override
    public FileHandler getFileHandler() {
        return this.fileHandler;
    }

    @Override
    public void setFileHandler(FileHandler fileHandler) {
        this.fileHandler = fileHandler;
    }

    protected final AntUtils getAntUtils() {
        return this.antUtils;
    }

    protected final ResourceUtils getResourceUtils() {
        return this.resourceUtils;
    }

    @Override
    public synchronized void addDeployable(Deployable newDeployable) {
        this.deployables.add(newDeployable);
    }

    @Override
    public List<Deployable> getDeployables() {
        return this.deployables;
    }

    @Override
    public String getHome() {
        return this.home;
    }

    @Override
    public void configure(LocalContainer container) {
        this.parsePropertiesForPendingConfiguration();
        this.verify();
        try {
            this.doConfigure(container);
        }
        catch (Exception e) {
            throw new ContainerException("Failed to create a " + container.getName() + " " + this.getType().getType() + " configuration", e);
        }
    }

    @Override
    public void verify() {
        this.collectUnsupportedResourcesAndThrowException();
        this.collectUnsupportedDataSourcesAndThrowException();
        super.verify();
    }

    public void collectUnsupportedResourcesAndThrowException() {
        if (!this.getResources().isEmpty() && !this.getCapability().supportsProperty("cargo.resource.resource")) {
            StringBuilder errorMessage = new StringBuilder();
            for (Resource resource : this.getResources()) {
                String message = "This configuration does not support Resource configuration! JndiName: " + resource.getName();
                this.getLogger().warn(message, this.getClass().getName());
                if (!errorMessage.toString().equals("")) {
                    errorMessage.append("\n");
                }
                errorMessage.append(message);
            }
            throw new CargoException(errorMessage.toString());
        }
    }

    public void collectUnsupportedDataSourcesAndThrowException() {
        StringBuilder errorMessage = new StringBuilder();
        for (DataSource dataSource : this.getDataSources()) {
            String reason = null;
            if (!this.getCapability().supportsProperty("cargo.datasource.datasource")) {
                reason = "This configuration does not support DataSource configuration! ";
            } else if ("javax.sql.XADataSource".toString().equals(dataSource.getConnectionType()) && !this.getCapability().supportsProperty("cargo.datasource.type")) {
                reason = "This configuration does not support XADataSource configured DataSources! ";
            } else if (!("javax.sql.XADataSource".toString().equals(dataSource.getConnectionType()) || TransactionSupport.NO_TRANSACTION.equals(dataSource.getTransactionSupport()) || this.getCapability().supportsProperty("cargo.datasource.transactionsupport"))) {
                reason = "This configuration does not support Transactions on Driver configured DataSources! ";
            }
            if (reason == null) continue;
            String message = reason + "JndiName: " + dataSource.getJndiLocation();
            if (!errorMessage.toString().equals("")) {
                errorMessage.append("\n");
            }
            errorMessage.append(message);
            this.getLogger().warn(message, this.getClass().getName());
        }
        if (!errorMessage.toString().equals("")) {
            throw new CargoException(errorMessage.toString());
        }
    }

    public void parsePropertiesForPendingConfiguration() {
        this.addResourcesFromProperties();
        this.addDataSourcesFromProperties();
    }

    protected void addResourcesFromProperties() {
        this.getLogger().debug("Searching properties for Resource definitions", this.getClass().getName());
        for (Map.Entry<String, String> property : this.getProperties().entrySet()) {
            String propertyName = property.getKey();
            if (!propertyName.startsWith("cargo.resource.resource")) continue;
            String resourceProperty = property.getValue();
            this.getLogger().debug("Found Resource definition: value [" + resourceProperty + "]", this.getClass().getName());
            Resource resource = new ResourceConverter().fromPropertyString(resourceProperty);
            this.getResources().add(resource);
        }
    }

    protected void addDataSourcesFromProperties() {
        this.getLogger().debug("Searching properties for DataSource definitions", this.getClass().getName());
        for (Map.Entry<String, String> property : this.getProperties().entrySet()) {
            String propertyName = property.getKey();
            if (!propertyName.startsWith("cargo.datasource.datasource")) continue;
            String dataSourceProperty = property.getValue();
            this.getLogger().debug("Found DataSource definition: value [" + dataSourceProperty + "]", this.getClass().getName());
            DataSource dataSource = new DataSourceConverter().fromPropertyString(dataSourceProperty);
            this.getDataSources().add(dataSource);
        }
    }

    protected abstract void doConfigure(LocalContainer var1) throws Exception;

    @Override
    public void addResource(Resource resource) {
        this.resources.add(resource);
    }

    @Override
    public List<Resource> getResources() {
        return this.resources;
    }

    @Override
    public void addDataSource(DataSource dataSource) {
        this.dataSources.add(dataSource);
    }

    @Override
    public List<DataSource> getDataSources() {
        return this.dataSources;
    }
}

