/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.wicket.resource.IPropertiesLoader;
import org.apache.wicket.util.value.ValueMap;

public class UtfPropertiesFilePropertiesLoader
implements IPropertiesLoader {
    private final String fileExtension;
    private final String encoding;
    private Method load;

    public UtfPropertiesFilePropertiesLoader(String fileExtension, String encoding) {
        this.fileExtension = fileExtension;
        this.encoding = encoding;
        try {
            this.load = Properties.class.getMethod("load", Reader.class);
        }
        catch (NoSuchMethodException ex) {
            this.load = null;
        }
    }

    @Override
    public final String getFileExtension() {
        return this.fileExtension;
    }

    @Override
    public Properties loadJavaProperties(InputStream in) throws IOException {
        if (this.load == null) {
            return null;
        }
        Properties properties = new Properties();
        InputStreamReader reader = new InputStreamReader(in, this.encoding);
        try {
            this.load.invoke((Object)properties, reader);
        }
        catch (IllegalArgumentException ex) {
            properties = null;
        }
        catch (IllegalAccessException ex) {
            properties = null;
        }
        catch (InvocationTargetException ex) {
            properties = null;
        }
        return properties;
    }

    @Override
    public ValueMap loadWicketProperties(InputStream inputStream) {
        return null;
    }
}

