/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.parser.filter;

import java.text.ParseException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.parser.AbstractMarkupFilter;
import org.apache.wicket.markup.parser.XmlTag;

public final class HtmlHeaderSectionHandler
extends AbstractMarkupFilter {
    private static final String BODY = "body";
    private static final String HEAD = "head";
    public static final String HEADER_ID = "_header_";
    private boolean foundHead = false;
    private boolean foundClosingHead = false;
    private boolean ignoreTheRest = false;
    private final Markup markup;

    public HtmlHeaderSectionHandler(Markup markup) {
        this.markup = markup;
    }

    @Override
    protected final MarkupElement onComponentTag(ComponentTag tag) throws ParseException {
        if (this.ignoreTheRest) {
            return tag;
        }
        if (HEAD.equalsIgnoreCase(tag.getName())) {
            if (tag.getNamespace() == null) {
                if (tag.isOpen()) {
                    this.foundHead = true;
                    if (tag.getId() == null) {
                        tag.setId(HEADER_ID);
                        tag.setAutoComponentTag(true);
                        tag.setModified(true);
                    }
                } else if (tag.isClose()) {
                    this.foundClosingHead = true;
                }
                return tag;
            }
            this.foundHead = true;
            this.foundClosingHead = true;
        } else if (BODY.equalsIgnoreCase(tag.getName()) && tag.getNamespace() == null) {
            if (this.foundHead && !this.foundClosingHead) {
                throw new MarkupException(new MarkupStream(this.markup), "Invalid page markup. Tag <BODY> found inside <HEAD>");
            }
            if (!this.foundHead) {
                this.insertHeadTag();
            }
            this.ignoreTheRest = true;
            return tag;
        }
        return tag;
    }

    private void insertHeadTag() {
        ComponentTag openTag = new ComponentTag(HEAD, XmlTag.TagType.OPEN);
        openTag.setId(HEADER_ID);
        openTag.setAutoComponentTag(true);
        openTag.setModified(true);
        ComponentTag closeTag = new ComponentTag(HEAD, XmlTag.TagType.CLOSE);
        closeTag.setOpenTag(openTag);
        closeTag.setModified(true);
        this.markup.addMarkupElement(openTag);
        this.markup.addMarkupElement(closeTag);
    }
}

